/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.ext.core.classes;

import php.runtime.Memory;
import php.runtime.annotation.Reflection;
import php.runtime.env.Environment;
import php.runtime.lang.BaseObject;
import php.runtime.memory.ArrayMemory;
import php.runtime.memory.LongMemory;
import php.runtime.memory.ObjectMemory;
import php.runtime.memory.StringMemory;
import php.runtime.memory.TrueMemory;
import php.runtime.reflection.ClassEntity;

@Reflection.Name(value="php\\lang\\ThreadGroup")
public class WrapThreadGroup
extends BaseObject {
    protected ThreadGroup group;

    public WrapThreadGroup(Environment env, ThreadGroup group) {
        super(env);
        this.group = group;
    }

    public WrapThreadGroup(Environment env, ClassEntity clazz) {
        super(env, clazz);
    }

    public ThreadGroup getGroup() {
        return this.group;
    }

    public void setGroup(ThreadGroup group) {
        this.group = group;
    }

    public WrapThreadGroup(Environment env) {
        super(env);
    }

    @Reflection.Signature(value={@Reflection.Arg(value="name"), @Reflection.Arg(value="parent", typeClass="php\\lang\\ThreadGroup", optional=@Reflection.Optional(value="NULL"))})
    public Memory __construct(Environment env, Memory ... args) {
        if (args[1].isNull()) {
            this.setGroup(new ThreadGroup(args[0].toString()));
        } else {
            this.setGroup(new ThreadGroup(args[1].toObject(WrapThreadGroup.class).getGroup(), args[0].toString()));
        }
        return Memory.NULL;
    }

    @Reflection.Signature
    public Memory __debugInfo(Environment env, Memory ... args) {
        ArrayMemory r = new ArrayMemory();
        r.refOfIndex("*name").assign(this.group.getName());
        r.refOfIndex("*maxPriority").assign(this.group.getMaxPriority());
        if (this.group.getParent() != null) {
            r.refOfIndex("*parentName").assign(this.group.getParent().getName());
        }
        return r.toConstant();
    }

    @Reflection.Signature
    public Memory getActiveCount(Environment env, Memory ... args) {
        return LongMemory.valueOf(this.group.activeCount());
    }

    @Reflection.Signature
    public Memory getActiveGroupCount(Environment env, Memory ... args) {
        return LongMemory.valueOf(this.group.activeGroupCount());
    }

    @Reflection.Signature
    public Memory getName(Environment env, Memory ... args) {
        return StringMemory.valueOf(this.group.getName());
    }

    @Reflection.Signature
    public Memory isDaemon(Environment env, Memory ... args) {
        return TrueMemory.valueOf(this.group.isDaemon());
    }

    @Reflection.Signature
    public Memory isDestroyed(Environment env, Memory ... args) {
        return TrueMemory.valueOf(this.group.isDestroyed());
    }

    @Reflection.Signature
    public Memory getMaxPriority(Environment env, Memory ... args) {
        return LongMemory.valueOf(this.group.getMaxPriority());
    }

    @Reflection.Signature(value={@Reflection.Arg(value="value")})
    public Memory setDaemon(Environment env, Memory ... args) {
        this.group.setDaemon(args[0].toBoolean());
        return Memory.NULL;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="value")})
    public Memory setMaxPriority(Environment env, Memory ... args) {
        this.group.setMaxPriority(args[0].toInteger());
        return Memory.NULL;
    }

    @Reflection.Signature
    public Memory destroy(Environment env, Memory ... args) {
        this.group.destroy();
        return Memory.NULL;
    }

    @Reflection.Signature
    public Memory checkAccess(Environment env, Memory ... args) {
        this.group.checkAccess();
        return Memory.NULL;
    }

    @Reflection.Signature
    public Memory interrupt(Environment env, Memory ... args) {
        this.group.interrupt();
        return Memory.NULL;
    }

    @Reflection.Signature
    public Memory getParent(Environment env, Memory ... args) {
        if (this.group.getParent() == null) {
            return Memory.NULL;
        }
        return new ObjectMemory(new WrapThreadGroup(env, this.group.getParent()));
    }
}

