/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.ext.core.classes.stream;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import php.runtime.Memory;
import php.runtime.annotation.Reflection;
import php.runtime.env.Environment;
import php.runtime.ext.core.classes.stream.Stream;
import php.runtime.memory.ArrayMemory;
import php.runtime.memory.BinaryMemory;
import php.runtime.memory.LongMemory;
import php.runtime.memory.StringMemory;
import php.runtime.reflection.ClassEntity;

@Reflection.Name(value="php\\io\\ResourceStream")
public class ResourceStream
extends Stream {
    protected InputStream stream;
    protected long position = 0L;
    protected boolean eof = false;
    protected URL url;

    public ResourceStream(Environment env, InputStream stream) {
        super(env);
        this.stream = stream;
    }

    public ResourceStream(Environment env, ClassEntity clazz) {
        super(env, clazz);
    }

    public URL getUrl() {
        return this.url;
    }

    public InputStream getInputStream() {
        return this.stream;
    }

    @Override
    @Reflection.Signature(value={@Reflection.Arg(value="path")})
    public Memory __construct(Environment env, Memory ... args) throws IOException {
        super.__construct(env, args[0], StringMemory.valueOf("r"));
        String path = this.getPath().replace('\\', '/').replace("//", "/");
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        this.setPath("res://" + path);
        this.url = env.getScope().getClassLoader().getResource(path);
        if (this.url == null) {
            throw new IOException("Resource not found - " + this.getPath());
        }
        this.stream = this.url.openStream();
        return Memory.NULL;
    }

    @Reflection.Signature
    public Memory toExternalForm(Environment env, Memory ... args) {
        return StringMemory.valueOf(this.url.toExternalForm());
    }

    @Override
    @Reflection.Signature
    public Memory write(Environment env, Memory ... args) throws IOException {
        throw new IOException("Stream only for reading");
    }

    @Override
    @Reflection.Signature
    public Memory read(Environment env, Memory ... args) throws IOException {
        int len = args[0].toInteger();
        if (len <= 0) {
            return Memory.FALSE;
        }
        byte[] buff = new byte[len];
        int read = this.stream.read(buff, 0, len);
        boolean bl = this.eof = read == -1;
        if (read == -1) {
            return Memory.NULL;
        }
        this.position += (long)read;
        if (read != buff.length) {
            buff = Arrays.copyOf(buff, read);
        }
        return new BinaryMemory(buff);
    }

    @Override
    @Reflection.Signature
    public Memory readFully(Environment env, Memory ... args) throws IOException {
        int read;
        ByteArrayOutputStream tmp = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        while ((read = this.stream.read(buf)) > 0) {
            tmp.write(buf, 0, read);
            this.position += (long)read;
        }
        return new BinaryMemory(tmp.toByteArray());
    }

    @Override
    @Reflection.Signature
    public Memory eof(Environment env, Memory ... args) {
        return this.eof ? Memory.TRUE : Memory.FALSE;
    }

    @Override
    @Reflection.Signature
    public Memory seek(Environment env, Memory ... args) throws IOException {
        throw new IOException("Cannot seek");
    }

    @Override
    @Reflection.Signature
    public Memory getPosition(Environment env, Memory ... args) {
        return LongMemory.valueOf(this.position);
    }

    @Override
    @Reflection.Signature
    public Memory close(Environment env, Memory ... args) throws IOException {
        this.stream.close();
        return Memory.NULL;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="name")})
    public static Memory exists(Environment env, Memory ... args) throws IOException {
        String name = args[0].toString();
        if (name.startsWith("res:///")) {
            name = name.substring(7);
        } else if (name.startsWith("res://")) {
            name = name.substring(6);
        }
        return env.getScope().getClassLoader().getResource(name) == null ? Memory.FALSE : Memory.TRUE;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="name")})
    public static Memory getResources(Environment env, Memory ... args) throws IOException {
        Enumeration<URL> list = env.getScope().getClassLoader().getResources(args[0].toString());
        ArrayMemory r = new ArrayMemory();
        while (list.hasMoreElements()) {
            URL url = list.nextElement();
            if (url == null) continue;
            ResourceStream rs = new ResourceStream(env, url.openStream());
            rs.setPath("res://" + args[0]);
            r.add(rs);
        }
        return r.toConstant();
    }
}

