/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.ext.core.classes.time;

import java.util.HashSet;
import java.util.Timer;
import java.util.TimerTask;
import php.runtime.annotation.Reflection;
import php.runtime.env.Environment;
import php.runtime.invoke.Invoker;
import php.runtime.lang.BaseWrapper;
import php.runtime.reflection.ClassEntity;

@Reflection.Name(value="php\\time\\Timer")
public class WrapTimer
extends BaseWrapper<TimerTask> {
    private static Timer timer = new Timer("php\\time\\Timer");

    public WrapTimer(Environment env, TimerTask wrappedObject) {
        super(env, wrappedObject);
    }

    public WrapTimer(Environment env, ClassEntity clazz) {
        super(env, clazz);
    }

    @Reflection.Signature
    protected void __construct() {
    }

    @Reflection.Signature
    public void cancel() {
        ((TimerTask)this.getWrappedObject()).cancel();
    }

    @Reflection.Signature
    public void run() {
        ((TimerTask)this.getWrappedObject()).run();
    }

    @Reflection.Signature
    public long scheduledTime() {
        return ((TimerTask)this.getWrappedObject()).scheduledExecutionTime();
    }

    @Reflection.Signature
    public static long parsePeriod(String period) {
        if (period == null || period.trim().isEmpty()) {
            throw new IllegalArgumentException("Invalid period - '" + period + "', is empty");
        }
        period = period.trim();
        String[] split = period.split(" ");
        long value = 0L;
        HashSet<Character> types = new HashSet<Character>();
        for (String one : split) {
            if (one.trim().isEmpty()) continue;
            one = one.trim();
            char t = one.charAt(one.length() - 1);
            int k = 1;
            switch (Character.toLowerCase(t)) {
                case 's': {
                    k = 1000;
                    break;
                }
                case 'm': {
                    k = 60000;
                    break;
                }
                case 'h': {
                    k = 3600000;
                    break;
                }
                case 'd': {
                    k = 86400000;
                    break;
                }
                default: {
                    if (Character.isDigit(t)) break;
                    throw new IllegalArgumentException("Invalid period - '" + period + "', at '" + one + "'");
                }
            }
            String num = one;
            if (!Character.isDigit(t)) {
                if (!types.add(Character.valueOf(t))) {
                    throw new IllegalArgumentException("Invalid period - '" + period + "', at '" + one + "' that duplicates '" + t + "'");
                }
                num = one.substring(0, one.length() - 1);
            }
            try {
                double v = Double.parseDouble(num);
                value += Math.round(v * (double)k);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid period - " + period + ", at '" + one + "', " + e.getMessage());
            }
        }
        return value;
    }

    @Reflection.Signature
    public static TimerTask after(String period, Invoker invoker) {
        return WrapTimer.setTimeout(invoker, WrapTimer.parsePeriod(period));
    }

    @Reflection.Signature
    public static TimerTask every(String period, Invoker invoker) {
        return WrapTimer.setInterval(invoker, WrapTimer.parsePeriod(period));
    }

    @Reflection.Signature
    public static TimerTask setTimeout(final Invoker invoker, long millis) {
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                invoker.callAny(this);
            }
        };
        timer.schedule(task, millis);
        return task;
    }

    @Reflection.Signature
    public static TimerTask setInterval(final Invoker invoker, long millis) {
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                invoker.callAny(this);
            }
        };
        timer.schedule(task, millis, millis);
        return task;
    }

    @Reflection.Signature
    public static void cancelAll() {
        timer.cancel();
        timer.purge();
    }
}

