/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.ext.core.reflection;

import php.runtime.Memory;
import php.runtime.annotation.Reflection;
import php.runtime.common.HintType;
import php.runtime.env.Environment;
import php.runtime.ext.core.reflection.Reflection;
import php.runtime.ext.support.Extension;
import php.runtime.ext.support.compile.CompileConstant;
import php.runtime.memory.ArrayMemory;
import php.runtime.memory.StringMemory;
import php.runtime.reflection.ClassEntity;
import php.runtime.reflection.support.ReflectionUtils;

@Reflection.Name(value="ReflectionExtension")
@Reflection.Signature(value={@Reflection.Arg(value="name", type=HintType.STRING)})
public class ReflectionExtension
extends Reflection {
    private Extension extension;

    public ReflectionExtension(Environment env, ClassEntity clazz) {
        super(env, clazz);
    }

    public ReflectionExtension(Environment env) {
        super(env);
    }

    public void setExtension(Extension extension) {
        this.extension = extension;
        this.getProperties().put("name", new StringMemory(extension.getName()));
    }

    @Reflection.Signature(value={@Reflection.Arg(value="name")})
    public Memory __construct(Environment env, Memory ... args) {
        String name = args[0].toString();
        this.extension = env.scope.getExtension(name);
        if (this.extension == null) {
            this.exception(env, "Extension %s does not exist", name);
        }
        this.setExtension(this.extension);
        return Memory.NULL;
    }

    @Reflection.Signature
    public Memory getName(Environment env, Memory ... args) {
        return new StringMemory(this.extension.getName());
    }

    @Reflection.Signature
    public Memory getVersion(Environment env, Memory ... args) {
        String ver = this.extension.getVersion();
        if ("~".equals(ver)) {
            ver = "0.9.0";
        }
        return new StringMemory(ver);
    }

    @Reflection.Signature
    public Memory getClassNames(Environment env, Memory ... args) {
        ArrayMemory result = new ArrayMemory();
        for (Class<?> e : this.extension.getClasses()) {
            result.add(ReflectionUtils.getClassName(e));
        }
        return result.toConstant();
    }

    @Reflection.Signature
    public Memory getConstants(Environment env, Memory ... args) {
        ArrayMemory result = new ArrayMemory();
        for (CompileConstant e : this.extension.getConstants().values()) {
            result.put(e.name, e.value);
        }
        return result.toConstant();
    }

    @Reflection.Signature
    public Memory getDependencies(Environment env, Memory ... args) {
        ArrayMemory result = new ArrayMemory();
        for (String name : this.extension.getRequiredExtensions()) {
            result.put(name, new StringMemory("Required"));
        }
        for (String name : this.extension.getOptionalExtensions()) {
            result.put(name, new StringMemory("Optional"));
        }
        for (String name : this.extension.getConflictExtensions()) {
            result.put(name, new StringMemory("Conflicts"));
        }
        return result.toConstant();
    }

    @Reflection.Signature
    public Memory getINIEntries(Environment env, Memory ... args) {
        return ArrayMemory.ofStringMap(this.extension.getINIEntries());
    }

    @Reflection.Signature
    public Memory isPersistent(Environment env, Memory ... args) {
        return Memory.TRUE;
    }

    @Reflection.Signature
    public Memory isTemporary(Environment env, Memory ... args) {
        return Memory.FALSE;
    }

    @Reflection.Signature
    public Memory info(Environment env, Memory ... args) {
        this.exception(env, "Method '%s' not supported in JPHP", "info");
        return Memory.NULL;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="reflector", type=HintType.OBJECT), @Reflection.Arg(value="return", type=HintType.BOOLEAN, optional=@Reflection.Optional(value="", type=HintType.BOOLEAN))})
    public static Memory export(Environment env, Memory ... args) {
        ReflectionExtension e = new ReflectionExtension(env, env.fetchClass("ReflectionExtension"));
        if (args[1].toBoolean()) {
            return e.__toString(env, new Memory[0]);
        }
        env.echo(e.__toString(env, new Memory[0]));
        return Memory.NULL;
    }
}

