/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.ext.java;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import php.runtime.Memory;
import php.runtime.annotation.Reflection;
import php.runtime.common.HintType;
import php.runtime.env.Environment;
import php.runtime.ext.java.JavaField;
import php.runtime.ext.java.JavaMethod;
import php.runtime.ext.java.JavaObject;
import php.runtime.ext.java.JavaReflection;
import php.runtime.memory.ArrayMemory;
import php.runtime.memory.LongMemory;
import php.runtime.memory.ObjectMemory;
import php.runtime.memory.StringMemory;
import php.runtime.memory.support.MemoryUtils;
import php.runtime.reflection.ClassEntity;

@Reflection.Name(value="php\\lang\\JavaClass")
public final class JavaClass
extends JavaReflection {
    protected Class<?> clazz;
    private static final Map<String, Class<?>> primitives = new HashMap<String, Class<?>>(){
        {
            this.put("int", Integer.TYPE);
            this.put("byte", Byte.TYPE);
            this.put("short", Short.TYPE);
            this.put("char", Character.TYPE);
            this.put("long", Long.TYPE);
            this.put("float", Float.TYPE);
            this.put("double", Double.TYPE);
            this.put("boolean", Boolean.TYPE);
            this.put("string", String.class);
        }
    };

    public JavaClass(Environment env, Class<?> clazz) {
        super(env);
        this.clazz = clazz;
    }

    public JavaClass(Environment env, ClassEntity clazz) {
        super(env, clazz);
    }

    @Reflection.Signature(value={@Reflection.Arg(value="class")})
    public Memory __construct(Environment env, Memory ... args) {
        try {
            this.setClazz(Class.forName(args[0].toString()));
        }
        catch (ClassNotFoundException e) {
            JavaClass.exception(env, e);
        }
        return Memory.NULL;
    }

    public void setClazz(Class<?> clazz) {
        this.clazz = clazz;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="name")})
    public Memory __get(Environment env, Memory ... args) {
        String name = args[0].toString();
        try {
            Field field = this.clazz.getField(name);
            field.setAccessible(true);
            return MemoryUtils.valueOf(env, field.get(null));
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            JavaClass.exception(env, e);
            return Memory.NULL;
        }
    }

    @Reflection.Signature(value={@Reflection.Arg(value="name"), @Reflection.Arg(value="value")})
    public Memory __set(Environment env, Memory ... args) {
        String name = args[0].toString();
        try {
            Field field = this.clazz.getField(name);
            field.setAccessible(true);
            field.set(null, MemoryUtils.fromMemory(args[1], field.getType()));
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            JavaClass.exception(env, e);
        }
        return Memory.NULL;
    }

    @Reflection.Signature
    public Memory isInterface(Environment env, Memory ... args) {
        return this.clazz.isInterface() ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory isAnnotation(Environment env, Memory ... args) {
        return this.clazz.isAnnotation() ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory isEnum(Environment env, Memory ... args) {
        return this.clazz.isEnum() ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory isArray(Environment env, Memory ... args) {
        return this.clazz.isArray() ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory isPrimitive(Environment env, Memory ... args) {
        return this.clazz.isPrimitive() ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory isAnonymousClass(Environment env, Memory ... args) {
        return this.clazz.isAnonymousClass() ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory isMemberClass(Environment env, Memory ... args) {
        return this.clazz.isMemberClass() ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory isFinal(Environment env, Memory ... args) {
        return Modifier.isFinal(this.clazz.getModifiers()) ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory isAbstract(Environment env, Memory ... args) {
        return Modifier.isAbstract(this.clazz.getModifiers()) ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory getName(Environment env, Memory ... args) {
        return new StringMemory(this.clazz.getName());
    }

    @Reflection.Signature
    public Memory getSimpleName(Environment env, Memory ... args) {
        return new StringMemory(this.clazz.getSimpleName());
    }

    @Reflection.Signature
    public Memory getSuperClass(Environment env, Memory ... args) {
        return this.clazz.getSuperclass() == null ? Memory.NULL : new ObjectMemory(JavaClass.of(env, this.clazz.getSuperclass()));
    }

    @Reflection.Signature
    public Memory getCanonicalName(Environment env, Memory ... args) {
        return new StringMemory(this.clazz.getCanonicalName());
    }

    @Reflection.Signature
    public Memory getModifiers(Environment env, Memory ... args) {
        return LongMemory.valueOf(this.clazz.getModifiers());
    }

    @Reflection.Signature(value={@Reflection.Arg(value="annotationClass")})
    public Memory isAnnotationPresent(Environment env, Memory ... args) {
        try {
            return this.clazz.isAnnotationPresent(Class.forName(args[0].toString())) ? Memory.TRUE : Memory.FALSE;
        }
        catch (ClassCastException | ClassNotFoundException e) {
            JavaClass.exception(env, e);
            return Memory.NULL;
        }
    }

    @Reflection.Signature
    public Memory getComponentType(Environment env, Memory ... args) {
        return new ObjectMemory(JavaClass.of(env, this.clazz.getComponentType()));
    }

    @Reflection.Signature
    public Memory getInterfaces(Environment env, Memory ... args) {
        ArrayMemory result = new ArrayMemory();
        for (Class<?> el : this.clazz.getInterfaces()) {
            result.add(new ObjectMemory(JavaClass.of(env, el)));
        }
        return result.toConstant();
    }

    @Reflection.Signature(value={@Reflection.Arg(value="name"), @Reflection.Arg(value="types", type=HintType.ARRAY, optional=@Reflection.Optional(type=HintType.ARRAY))})
    public Memory getDeclaredMethod(Environment env, Memory ... args) {
        try {
            return new ObjectMemory(JavaMethod.of(env, this.clazz.getDeclaredMethod(args[0].toString(), JavaClass.types(env, args[1].toValue(ArrayMemory.class)))));
        }
        catch (NoSuchMethodException e) {
            JavaClass.exception(env, e);
            return Memory.NULL;
        }
    }

    @Reflection.Signature
    public Memory getDeclaredMethods(Environment env, Memory ... args) {
        ArrayMemory result = new ArrayMemory();
        for (Method method : this.clazz.getDeclaredMethods()) {
            result.add(new ObjectMemory(JavaMethod.of(env, method)));
        }
        return result.toConstant();
    }

    @Reflection.Signature(value={@Reflection.Arg(value="name")})
    public Memory getDeclaredField(Environment env, Memory ... args) {
        try {
            Field field = this.clazz.getDeclaredField(args[0].toString());
            return new ObjectMemory(JavaField.of(env, field));
        }
        catch (NoSuchFieldException e) {
            JavaClass.exception(env, e);
            return Memory.NULL;
        }
    }

    @Reflection.Signature
    public Memory getDeclaredFields(Environment env, Memory ... args) {
        ArrayMemory result = new ArrayMemory();
        for (Field field : this.clazz.getDeclaredFields()) {
            result.put(field.getName(), new ObjectMemory(JavaField.of(env, field)));
        }
        return result.toConstant();
    }

    @Reflection.Signature
    public Memory newInstance(Environment env, Memory ... args) {
        try {
            return new ObjectMemory(JavaObject.of(env, this.clazz.newInstance()));
        }
        catch (IllegalAccessException | InstantiationException e) {
            JavaClass.exception(env, e);
            return Memory.NULL;
        }
    }

    @Reflection.Signature(value={@Reflection.Arg(value="types", type=HintType.ARRAY), @Reflection.Arg(value="arguments", type=HintType.ARRAY)})
    public Memory newInstanceArgs(Environment env, Memory ... args) {
        try {
            Constructor<?> constructor = this.clazz.getConstructor(JavaClass.types(env, args[0].toValue(ArrayMemory.class)));
            MemoryUtils.Converter[] converters = MemoryUtils.getConverters(constructor.getParameterTypes());
            Memory[] passed = args[1].toValue(ArrayMemory.class).values();
            if (passed.length != converters.length) {
                throw new IllegalArgumentException("Invalid argument count");
            }
            return new ObjectMemory(JavaObject.of(env, constructor.newInstance(JavaMethod.makePassed(env, converters, passed))));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException e) {
            JavaClass.exception(env, e);
        }
        catch (InvocationTargetException e) {
            JavaClass.exception(env, e.getTargetException());
        }
        return Memory.NULL;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="class", nativeType=JavaClass.class)})
    public Memory isAssignableFrom(Environment env, Memory ... args) {
        JavaClass javaClass = (JavaClass)args[0].toValue(ObjectMemory.class).value;
        return this.clazz.isAssignableFrom(javaClass.clazz) ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="className")})
    public Memory isSubClass(Environment env, Memory ... args) {
        try {
            Class<?> clazz = Class.forName(args[0].toString());
            return clazz.isAssignableFrom(clazz) ? Memory.TRUE : Memory.FALSE;
        }
        catch (ClassNotFoundException e) {
            JavaClass.exception(env, e);
            return Memory.FALSE;
        }
    }

    @Reflection.Signature
    public Memory getEnumConstants(Environment env, Memory ... args) {
        ArrayMemory result = new ArrayMemory();
        for (Object el : this.clazz.getEnumConstants()) {
            result.add(new ObjectMemory(JavaObject.of(env, el)));
        }
        return result;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="name")})
    public Memory getResource(Environment env, Memory ... args) {
        URL url = this.clazz.getResource(args[0].toString());
        if (url == null || url.getFile() == null) {
            return Memory.NULL;
        }
        return new StringMemory(url.getFile());
    }

    public static JavaClass of(Environment env, Class<?> clazz) {
        return new JavaClass(env, clazz);
    }

    @Reflection.Signature(value={@Reflection.Arg(value="name")})
    public static Memory primitive(Environment env, Memory ... args) {
        String name = args[0].toString();
        Class<?> cls = primitives.get(name);
        if (cls == null || !cls.isPrimitive()) {
            JavaClass.exception(env, new ClassNotFoundException(name));
        }
        return new ObjectMemory(JavaClass.of(env, cls));
    }

    public static Class<?>[] types(Environment env, ArrayMemory arrays) {
        Class[] result = new Class[arrays.size()];
        int i = 0;
        for (Memory el : arrays.values()) {
            String name = el.toString();
            Class<?> cls = primitives.get(name);
            if (cls != null) {
                result[i] = cls;
            } else {
                try {
                    result[i] = Class.forName(name);
                }
                catch (ClassNotFoundException e) {
                    JavaClass.exception(env, e);
                }
            }
            ++i;
        }
        return result;
    }
}

