/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.ext.java;

import java.lang.reflect.Field;
import php.runtime.Memory;
import php.runtime.annotation.Reflection;
import php.runtime.env.Environment;
import php.runtime.ext.java.JavaClass;
import php.runtime.ext.java.JavaReflection;
import php.runtime.memory.ObjectMemory;
import php.runtime.memory.StringMemory;
import php.runtime.memory.support.MemoryUtils;
import php.runtime.reflection.ClassEntity;

@Reflection.Name(value="php\\lang\\JavaObject")
public final class JavaObject
extends JavaReflection {
    protected Object object;

    public JavaObject(Environment env, ClassEntity clazz) {
        super(env, clazz);
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public Object getObject() {
        return this.object;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="name")})
    public Memory __get(Environment env, Memory ... args) {
        String name = args[0].toString();
        try {
            Field field = this.object.getClass().getField(name);
            field.setAccessible(true);
            return MemoryUtils.valueOf(env, field.get(this.object));
        }
        catch (NoSuchFieldException e) {
            JavaObject.exception(env, e);
        }
        catch (IllegalAccessException e) {
            JavaObject.exception(env, e);
        }
        return Memory.NULL;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="name"), @Reflection.Arg(value="value")})
    public Memory __set(Environment env, Memory ... args) {
        String name = args[0].toString();
        try {
            Field field = this.object.getClass().getField(name);
            field.setAccessible(true);
            field.set(this.object, MemoryUtils.fromMemory(args[1], field.getType()));
        }
        catch (NoSuchFieldException e) {
            JavaObject.exception(env, e);
        }
        catch (IllegalAccessException e) {
            JavaObject.exception(env, e);
        }
        return Memory.NULL;
    }

    @Reflection.Name(value="getClass")
    @Reflection.Signature
    public Memory _getClass(Environment env, Memory ... args) {
        return new ObjectMemory(JavaClass.of(env, this.object.getClass()));
    }

    @Reflection.Signature
    public Memory getClassName(Environment env, Memory ... args) {
        return new StringMemory(this.object.getClass().getName());
    }

    public static JavaObject of(Environment env, Object value) {
        JavaObject javaObject = new JavaObject(env, env.fetchClass("php\\lang\\JavaObject"));
        javaObject.setObject(value);
        return javaObject;
    }
}

