/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.ext.support.compile;

import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import php.runtime.ext.support.compile.CompileFunction;

public class CompileFunctionSpec {
    protected String name;
    protected boolean asImmutable;
    protected String lowerName;
    protected List<Method> methods = new LinkedList<Method>();

    public CompileFunctionSpec(String name) {
        this(name, false);
    }

    public CompileFunctionSpec(String name, boolean asImmutable) {
        this.name = name;
        this.asImmutable = asImmutable;
        this.lowerName = name.toLowerCase();
    }

    public void addMethod(Method method) {
        this.methods.add(method);
    }

    public String getName() {
        return this.name;
    }

    public String getLowerName() {
        return this.lowerName;
    }

    public CompileFunction toFunction() {
        CompileFunction function = new CompileFunction(this.name);
        for (Method method : this.methods) {
            function.addMethod(method, this.asImmutable);
        }
        return function;
    }
}

