/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.invoke;

import php.runtime.Memory;
import php.runtime.common.Messages;
import php.runtime.env.Environment;
import php.runtime.env.TraceInfo;
import php.runtime.exceptions.CriticalException;
import php.runtime.exceptions.support.ErrorType;
import php.runtime.ext.core.classes.WrapInvoker;
import php.runtime.invoke.DynamicMethodInvoker;
import php.runtime.invoke.FunctionInvoker;
import php.runtime.invoke.StaticMethodInvoker;
import php.runtime.lang.ForeachIterator;
import php.runtime.memory.ObjectMemory;
import php.runtime.memory.support.MemoryOperation;
import php.runtime.reflection.ParameterEntity;

public abstract class Invoker
implements Cloneable {
    protected Environment env;
    protected TraceInfo trace;
    protected boolean pushCallTrace = true;
    private Object userData;

    protected Invoker(Environment env, TraceInfo trace) {
        this.env = env;
        this.trace = trace;
    }

    protected Invoker clone() throws CloneNotSupportedException {
        return (Invoker)super.clone();
    }

    public Object getUserData() {
        return this.userData;
    }

    public void setUserData(Object userData) {
        this.userData = userData;
    }

    public Invoker forEnvironment(Environment env) {
        try {
            Invoker clone = this.clone();
            clone.env = env;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new CriticalException(e);
        }
    }

    public Environment getEnvironment() {
        return this.env;
    }

    public void setPushCallTrace(boolean pushCallTrace) {
        this.pushCallTrace = pushCallTrace;
    }

    public void check(String name, TraceInfo trace) {
    }

    public abstract ParameterEntity[] getParameters();

    public abstract String getName();

    public abstract int getArgumentCount();

    protected abstract void pushCall(TraceInfo var1, Memory[] var2);

    protected abstract Memory invoke(Memory ... var1) throws Throwable;

    public final Memory call(Memory ... args) throws Throwable {
        this.trace = this.trace == null ? (this.env == null ? TraceInfo.UNKNOWN : this.env.trace()) : this.trace;
        return this.invoke(args);
    }

    public final Memory callAny(Object ... args) {
        if (args != null && args.length > 0) {
            Memory[] passed = new Memory[args.length];
            for (int i = 0; i < passed.length; ++i) {
                if (args[i] == null) {
                    passed[i] = Memory.NULL;
                    continue;
                }
                MemoryOperation operation = MemoryOperation.get(args[i].getClass(), args[i].getClass().getGenericSuperclass());
                if (operation == null) {
                    throw new CriticalException("Unsupported bind type - " + args[i].getClass().toString());
                }
                passed[i] = operation.unconvertNoThow(this.env, this.trace, args[i]);
            }
            return this.callNoThrow(passed);
        }
        return this.callNoThrow(new Memory[0]);
    }

    public Memory callNoThrow(Memory ... args) {
        try {
            return this.call(args);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    protected void popCall() {
        this.env.popCall();
    }

    public void setTrace(TraceInfo trace) {
        this.trace = trace;
    }

    @Deprecated
    public static Invoker valueOf(Environment env, Memory method) {
        return Invoker.valueOf(env, env.peekCall((int)0).trace, method);
    }

    public abstract int canAccess(Environment var1);

    public static Invoker create(Environment env, Memory method) {
        return Invoker.valueOf(env, null, method);
    }

    public static Invoker valueOf(Environment env, TraceInfo trace, Memory method) {
        if ((method = method.toValue()).isObject()) {
            if (method.toValue(ObjectMemory.class).value instanceof WrapInvoker) {
                return method.toObject(WrapInvoker.class).getInvoker();
            }
            return DynamicMethodInvoker.valueOf(env, trace, method);
        }
        if (method.isArray()) {
            Memory one = null;
            Memory two = null;
            ForeachIterator iterator = method.getNewIterator(env, false, false);
            while (iterator.next()) {
                if (one == null) {
                    one = iterator.getValue();
                    continue;
                }
                if (two != null) break;
                two = iterator.getValue();
            }
            if (one == null || two == null) {
                if (trace == null) {
                    return null;
                }
                env.error(trace, ErrorType.E_ERROR, Messages.ERR_CALL_TO_UNDEFINED_FUNCTION.fetch(method.toString()), new Object[0]);
            }
            assert (one != null);
            assert (two != null);
            String methodName = two.toString();
            if (one.isObject()) {
                return DynamicMethodInvoker.valueOf(env, trace, one.toValue(), methodName);
            }
            String className = one.toString();
            return StaticMethodInvoker.valueOf(env, trace, className, methodName);
        }
        String methodName = method.toString();
        int p = methodName.indexOf("::");
        if (p > -1) {
            String className = methodName.substring(0, p);
            methodName = methodName.substring(p + 2, methodName.length());
            return StaticMethodInvoker.valueOf(env, trace, className, methodName);
        }
        return FunctionInvoker.valueOf(env, trace, methodName);
    }
}

