/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.loader.dump;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import php.runtime.loader.dump.StandaloneLibrary;
import php.runtime.loader.dump.io.DumpException;
import php.runtime.loader.dump.io.DumpInputStream;
import php.runtime.loader.dump.io.DumpOutputStream;
import php.runtime.reflection.ModuleEntity;

public class StandaloneLibraryDumper {
    private static final String HASH = "\u0001\u0007\u0004\u0003\u0003";
    private StandaloneLibrary library = new StandaloneLibrary();

    public void addModule(ModuleEntity entity) {
        this.library.addModule(new StandaloneLibrary.Module(entity));
    }

    public void addModules(ModuleEntity ... entities) {
        for (ModuleEntity module : entities) {
            this.addModule(module);
        }
    }

    public void addModules(Iterable<ModuleEntity> entities) {
        for (ModuleEntity module : entities) {
            this.addModule(module);
        }
    }

    public StandaloneLibrary getLibrary() {
        return this.library;
    }

    public void save(OutputStream output) throws IOException {
        this.save(output, this.library);
    }

    public void save(OutputStream output, StandaloneLibrary library) throws IOException {
        DumpOutputStream data = new DumpOutputStream(output);
        data.writeName(HASH);
        data.writeName("0.9.0");
        data.writeName("5.6.99");
        data.writeInt(library.getModules().size());
        for (StandaloneLibrary.Module module : library.getModules().values()) {
            data.writeName(module.getName());
            data.writeName(module.getInternalName());
            data.writeInt(module.getClasses().size());
            for (String entity : module.getClasses()) {
                data.writeName(entity);
            }
            data.writeInt(module.getFunctions().size());
            for (String entity : module.getFunctions()) {
                data.writeName(entity);
            }
            data.writeInt(module.getConstants().size());
            for (String entity : module.getConstants()) {
                data.writeName(entity);
            }
        }
    }

    public StandaloneLibrary load(InputStream input) throws IOException {
        StandaloneLibrary library = new StandaloneLibrary();
        DumpInputStream data = new DumpInputStream(input);
        String hash = data.readName();
        if (!HASH.equals(hash)) {
            throw new DumpException("Invalid standalone modules, invalid hash");
        }
        String coreVersion = data.readName();
        String likePhpVersion = data.readName();
        library.setCoreVersion(coreVersion);
        library.setLikePhpVersion(likePhpVersion);
        int count = data.readInt();
        for (int i = 0; i < count; ++i) {
            String name = data.readName();
            String internalName = data.readName();
            int classesSize = data.readInt();
            HashSet<String> classes = new HashSet<String>();
            for (int j = 0; j < classesSize; ++j) {
                classes.add(data.readName());
            }
            int functionsSize = data.readInt();
            HashSet<String> functions = new HashSet<String>();
            for (int j = 0; j < functionsSize; ++j) {
                functions.add(data.readName());
            }
            int constantSize = data.readInt();
            HashSet<String> constants = new HashSet<String>();
            for (int j = 0; j < constantSize; ++j) {
                constants.add(data.readName());
            }
            StandaloneLibrary.Module module = new StandaloneLibrary.Module(name, internalName, classes, functions, constants);
            library.addModule(module);
        }
        return library;
    }
}

