/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.reflection;

import php.runtime.Memory;
import php.runtime.common.HintType;
import php.runtime.env.Context;
import php.runtime.env.Environment;
import php.runtime.env.TraceInfo;
import php.runtime.exceptions.CriticalException;
import php.runtime.exceptions.support.ErrorType;
import php.runtime.lang.BaseWrapper;
import php.runtime.memory.ObjectMemory;
import php.runtime.memory.support.MemoryOperation;
import php.runtime.reflection.ClassEntity;
import php.runtime.reflection.support.Entity;
import php.runtime.reflection.support.ReflectionUtils;
import php.runtime.reflection.support.TypeChecker;
import php.runtime.util.JVMStackTracer;

public class ParameterEntity
extends Entity {
    protected ClassEntity clazz;
    protected Memory defaultValue;
    protected String defaultValueConstName;
    protected boolean isReference;
    protected TypeChecker typeChecker;
    protected TypeHintingChecker typeHintingChecker;
    protected boolean mutable = true;
    protected boolean used = true;
    protected boolean nullable = false;
    protected boolean variadic = false;

    public ParameterEntity(Context context) {
        super(context);
    }

    public String getDefaultValueConstName() {
        return this.defaultValueConstName;
    }

    public void setDefaultValueConstName(String defaultValueConstName) {
        this.defaultValueConstName = defaultValueConstName;
    }

    public Memory getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Memory defaultValue) {
        this.defaultValue = defaultValue;
    }

    public ClassEntity getClazz() {
        return this.clazz;
    }

    private void setClazz(ClassEntity clazz) {
        this.clazz = clazz;
    }

    public boolean isReference() {
        return this.isReference;
    }

    public void setReference(boolean reference) {
        this.isReference = reference;
    }

    public TypeChecker getTypeChecker() {
        return this.typeChecker;
    }

    public void setTypeChecker(TypeChecker typeChecker) {
        this.typeChecker = typeChecker;
    }

    public HintType getType() {
        return this.typeChecker instanceof TypeChecker.Simple ? ((TypeChecker.Simple)this.typeChecker).getType() : HintType.ANY;
    }

    public String getTypeClass() {
        return this.typeChecker instanceof TypeChecker.ClassName ? ((TypeChecker.ClassName)this.typeChecker).getTypeClass() : null;
    }

    public String getTypeClassLower() {
        return this.typeChecker instanceof TypeChecker.ClassName ? ((TypeChecker.ClassName)this.typeChecker).getTypeClassLower() : null;
    }

    public void setType(HintType type) {
        this.typeChecker = type == null ? null : TypeChecker.of(type);
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public boolean isNullableOrDefaultNull() {
        return this.isNullable() || this.getDefaultValue() != null && this.getDefaultValue().isNull();
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    public void setTypeClass(String typeClass) {
        this.typeChecker = typeClass == null ? null : TypeChecker.of(typeClass);
    }

    public void setTypeNativeClass(Class<?> typeNativeClass) {
        Class<BaseWrapper> baseWrapper = MemoryOperation.getWrapper(typeNativeClass);
        if (baseWrapper == null) {
            throw new CriticalException("Support only wrapper classes");
        }
        this.typeChecker = TypeChecker.of(ReflectionUtils.getClassName(baseWrapper));
    }

    public void setType(String type) {
        HintType _type = HintType.of(type);
        this.typeChecker = _type == null ? null : TypeChecker.of(_type);
    }

    public Class<? extends Enum> getTypeEnum() {
        return this.typeChecker instanceof TypeChecker.EnumClass ? ((TypeChecker.EnumClass)this.typeChecker).getTypeEnum() : null;
    }

    public void setTypeEnum(Class<? extends Enum> typeEnum) {
        this.typeChecker = typeEnum == null ? null : TypeChecker.ofEnum(typeEnum);
    }

    public TypeHintingChecker getTypeHintingChecker() {
        return this.typeHintingChecker;
    }

    public void setTypeHintingChecker(TypeHintingChecker typeHintingChecker) {
        this.typeHintingChecker = typeHintingChecker;
    }

    public static void validateTypeHinting(Environment env, int index, Memory[] args, HintType type, boolean nullable) {
        Memory value = args[index - 1];
        if (!ParameterEntity.checkTypeHinting(env, value, type, nullable)) {
            String given = value == null ? "none" : (value.isObject() ? "instance of " + value.toValue(ObjectMemory.class).getReflection().getName() : value.getRealType().toString());
            StackTraceElement[] stack = Thread.currentThread().getStackTrace();
            StackTraceElement e = stack[2];
            StackTraceElement where = stack[3];
            TraceInfo trace = where.getLineNumber() <= 0 ? env.trace() : new TraceInfo(where);
            JVMStackTracer.Item item = new JVMStackTracer.Item(env.scope.getClassLoader(), e);
            env.error(trace, ErrorType.E_RECOVERABLE_ERROR, "Argument %s passed to %s() must be of the type %s, %s given", index, item.getSignature(), type.toString(), given);
        }
    }

    public static boolean checkTypeHinting(Environment env, Memory value, HintType type) {
        return ParameterEntity.checkTypeHinting(env, value, type, false);
    }

    public static boolean checkTypeHinting(Environment env, Memory value, HintType type, boolean nullable) {
        return ParameterEntity.checkTypeHinting(env, value, type, nullable, null);
    }

    public static boolean checkTypeHinting(Environment env, Memory value, HintType type, boolean nullable, String staticClassName) {
        if (nullable && value.isNull()) {
            return true;
        }
        return TypeChecker.of(type).check(env, value, nullable, staticClassName);
    }

    public boolean checkTypeHinting(Environment env, Memory value, String typeClass, boolean nullable) {
        if (nullable && value.isNull()) {
            return true;
        }
        if (!value.isObject()) {
            return false;
        }
        return TypeChecker.of(typeClass).check(env, value, nullable, null);
    }

    public boolean checkTypeHinting(Environment env, Memory value) {
        return this.checkTypeHinting(env, value, null);
    }

    public boolean checkTypeHinting(Environment env, Memory value, String staticClassName) {
        if (this.typeChecker != null) {
            return this.typeChecker.check(env, value, this.nullable || this.defaultValue != null && this.defaultValue.isNull(), staticClassName);
        }
        return true;
    }

    public Memory applyTypeHinting(Environment env, Memory value, boolean strict) {
        if (this.typeChecker != null) {
            return this.typeChecker.apply(env, value, this.nullable || this.defaultValue != null && this.defaultValue.isNotNull(), strict);
        }
        return null;
    }

    public boolean isArray() {
        return this.getType() == HintType.ARRAY;
    }

    public boolean isCallable() {
        return this.getType() == HintType.CALLABLE;
    }

    public boolean isOptional() {
        return this.defaultValue != null;
    }

    public boolean isDefaultValueAvailable() {
        return this.defaultValue != null;
    }

    public boolean canBePassedByValue() {
        return !this.isReference;
    }

    public boolean isPassedByReference() {
        return this.isReference;
    }

    public String getSignatureString() {
        String signature;
        StringBuilder sb = new StringBuilder();
        if (this.typeChecker != null && (signature = this.typeChecker.getSignature()) != null && !signature.isEmpty()) {
            sb.append(signature).append(" ");
        }
        if (this.isReference) {
            sb.append("&");
        }
        sb.append("$").append(this.name);
        return sb.toString();
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public void setMutable(boolean mutable) {
        this.mutable = mutable;
    }

    public boolean isUsed() {
        return this.used;
    }

    public void setUsed(boolean used) {
        this.used = used;
    }

    public boolean isVariadic() {
        return this.variadic;
    }

    public void setVariadic(boolean variadic) {
        this.variadic = variadic;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ParameterEntity)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ParameterEntity that = (ParameterEntity)o;
        if (this.isReference != that.isReference) {
            return false;
        }
        if (this.clazz != null ? !this.clazz.equals(that.clazz) : that.clazz != null) {
            return false;
        }
        return this.getType() == that.getType();
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.clazz != null ? this.clazz.hashCode() : 0);
        result = 31 * result + (this.isReference ? 1 : 0);
        result = 31 * result + (this.getType() != null ? this.getType().hashCode() : 0);
        return result;
    }

    public static interface TypeHintingChecker {
        public boolean call(Environment var1, Memory var2);

        public String getNeeded(Environment var1, Memory var2);
    }
}

