/* 

     \            |   _)       _ \         |     |                          
    _ \    __ \   __|  |      |   |   _ \  |  /  |   _` |  __ `__ \    _` | 
   ___ \   |   |  |    |      __ <    __/    <   |  (   |  |   |   |  (   | 
 _/    _\ _|  _| \__| _|     _| \_\ \___| _|\_\ _| \__,_| _|  _|  _| \__,_| 
			       ____   __  
			 __ __|__ /  /  \ 
			 \ V / |_ \_| () |
			  \_/ |___(_)\__/ 
			  
 __                  __   __   __            ___      __        ___      ___ 
|__) \ /    __ |  | |__) /  \ /__` __   &   |__  \_/ /  \ |    |__  |\ |  |  
|__)  |        \__/ |  \ \__/ .__/          |___ / \ \__/ |___ |___ | \|  |  
                                                                             






Anti Reklama v3.0

 Blocking IP address in chat, written in ANY form of numbers eg: (1 7 2, 16 . 2 5 4 , 1 ; 2 701 5)
 Not allow to player change nick to IP address
 Every time you try advertising opens MOTD warning window
 Every time you try to advertising that logs will be saved in amxmodx/logs/antireklama.txt
 Punishing player (Kill, Kick, Slap, Gag, Ban)

 antireklama_status <1/0> on/off
 antireklama_maxdigits <number> default: 12 (Dont allow more than 12 digits  in chat or player name))
 antireklama_prefix <Your server name> (Prefix in front of the posts) Also player nickname will be changed to "Your server name"
 antireklama_punish <1:6> default: 1 (Without Punishment)

1. Without Punishment 
2. Kill 
3. Kick 
4. Slap 
5. Gag 5 min 
6. Ban 5 min
*/


#include <amxmodx>
#include <geoip>

#define MAX_PLAYERS 32 
#define ACCESS	    ADMIN_RCON

enum 
{     
	CHECK_NO,     CHECK_FIRST,     CHECK_CHANGE 
}

new pCvar_MaxDigits
new pCvar_Prefix[21]
new pCvar_Status
new pCvar_Punish
new pcvar_Menu[40]
new szMessage[ 194 ]
new g_iCheckStatus[ MAX_PLAYERS + 1 ]
new ON_OFF

new const g_szNameKey[ ] = "name"

public plugin_init( ) 
{     

	register_plugin( "Anti Reklama", "3.0b", "Exolent/->UrOS<-" )
	register_dictionary("common.txt")
	
	register_cvar("antireklama", "3.0b" , (FCVAR_SERVER|FCVAR_SPONLY))
	register_srvcmd("antireklama_prefix", "AntiReklamaPrefix") 	
	
	register_clcmd( "say", "CmdSay" )
	register_clcmd( "say_team", "CmdSay" )
	
	register_clcmd("say /antireklama", "menuItem")
	register_clcmd("say_team /antireklama", "menuItem")
	
	pCvar_Status = register_cvar("antireklama_status", "1", ADMIN_RCON)  
	pCvar_Punish = register_cvar("antireklama_punish", "0", ADMIN_RCON)  	
	pCvar_MaxDigits = register_cvar( "antireklama_maxdigits", "12", ADMIN_RCON)
} 

public plugin_precache()
{
	precache_sound("vox/access.wav")
	precache_sound("vox/denied.wav")
}

public CmdSay( id ) 
{  
	if(get_pcvar_num(pCvar_Status) == 1)
   	{
		read_args( szMessage, charsmax( szMessage ) )
		remove_quotes( szMessage )
	   
		new iCount
		new iMax = get_pcvar_num( pCvar_MaxDigits )
	   
		new i = -1
		while( szMessage[ ++i ] )     
		{         	
			if( '0' <= szMessage[ i ] <= '9' )         
			{        
				if( ++iCount >= iMax )            
				{  				       
					AntiReklamaMotd( id )
					AntiReklamaLog( id, szMessage )	
					AntiReklamaPunish( id )				
					return PLUGIN_HANDLED
				}         
			}     
		}         
	}
	return PLUGIN_CONTINUE
}

public client_putinserver( id ) 
{  
	if(get_pcvar_num(pCvar_Status) == 1)
	{
		g_iCheckStatus[ id ] = CHECK_FIRST
	   
		new szName[ 32 ], text[512]
		get_user_name( id, szName, charsmax( szName ) )
	   
		if( !IsNameValid( szName ) )     
		{
			AntiReklamaLog( id, "The advertisement was in the name..." )	
			format(text,511,"%s Anti Reklama", pCvar_Prefix)
			AntiReklamaMotd( id )
			set_user_info( id, g_szNameKey, text)	
			AntiReklamaPunish( id )	
		}   
		g_iCheckStatus[ id ] = CHECK_CHANGE
	}
}

public client_disconnect( id ) 
{     
	g_iCheckStatus[ id ] = CHECK_NO
} 	
	
public client_infochanged( id ) 
{ 
	if(get_pcvar_num(pCvar_Status) == 1)
	{	    
		if( g_iCheckStatus[ id ] == CHECK_CHANGE )     
		{
			new newname[32],oldname[32], text[512]
			get_user_info(id, "name", newname,31)
			get_user_name(id, oldname,31)
			       
			if( !equal( newname, oldname)         &&  !IsNameValid(newname ) )         
			{   
				AntiReklamaLog( id, "The advertisement was in the name..." )
				format(text,511,"%s Anti Reklama", pCvar_Prefix)
				set_user_info( id, g_szNameKey, text) 
				AntiReklamaPunish( id )
				AntiReklamaMotd( id )
			}     
		}
	}
} 

bool:IsNameValid( const szName[ ] ) 
{     
	new iCount
	new iMax = get_pcvar_num( pCvar_MaxDigits )
	   
	new i = -1
	while( szName[ ++i ] )     
	{         
		if( '0' <= szName[ i ] <= '9' )         
		{            
			if( ++iCount >= iMax )             
			{                 
				return false
			}        
		}     
	}        
	return true
}

public AntiReklamaLog( id, szMessage[] )
{
	new szName[ 32 ], szAuthID[ 32 ], szUserIP[ 32 ], szCountry[ 32 ]

	get_user_name( id, szName, 31 )
	get_user_authid( id, szAuthID, 31 )
	get_user_ip( id, szUserIP, 31, 1 )
	geoip_country( szUserIP, szCountry )
	
	static szLogData[ 200 ]
	formatex( szLogData, sizeof szLogData - 1, "Nick: %s | ID: %s | IP: %s | Country: %s | %s", szName, szAuthID, szUserIP, szCountry, szMessage)
	log_to_file( "antireklama.log", szLogData )
	console_print( id, szLogData )

	return PLUGIN_HANDLED
}

public AntiReklamaPunish(id)
{		
	if ( get_pcvar_num(pCvar_Punish) == 2 )
	{
		client_cmd(id, "kill")
	}
	else if ( get_pcvar_num(pCvar_Punish) == 3 )
	{	
		server_cmd("amx_kick #%d ^"More information in console!^"",get_user_userid(id))
	}
	else if ( get_pcvar_num(pCvar_Punish) == 4 )
	{
		server_cmd("amx_slap #%d",get_user_userid(id))
	}
	else if ( get_pcvar_num(pCvar_Punish) == 5 )
	{
		server_cmd("amx_gag #%d 300 abc ",get_user_userid(id))
	}	
	else if ( get_pcvar_num(pCvar_Punish) == 6 )
	{	
		server_cmd("amx_ban #%d 5 ^"More information in console!^"",get_user_userid(id))
	}	
}

public AntiReklamaMotd(id) 
{ 	
	client_print( id, print_console, "^n*** If this wasn't advertising attempt, we're apologize ***^n")
	
	static motd[1501], len
		    
	len = format(motd, 1500,"<body bgcolor=#000000><font color=#87cefa><pre>")
	len += format(motd[len], 1500-len,"<h4 align='center'><font size='6' color='#FF0000'>%s Anti IP Advertising^n</font>", pCvar_Prefix)
	len += format(motd[len], 1500-len,"<h4 align='center'><font size='4' color='#FFFFFF'>Server advertising is forbidden!</font>")			
	len += format(motd[len], 1500-len,"<h4 align='center'><font size='4' color='#FFFFFF'>If this wasn't advertising attempt, we're apologize.^n^n^n</font>")
	len += format(motd[len], 1500-len,"<center><h4><font color=^"white^"><B>----------------------------</B> </font></h4></center>")	
	len += format(motd[len], 1500-len,"<h4 align='center'><font size='1' color='#FF0000'><h4>Authors: Exolent & ->UrOS<-</h4></font>")
	len += format(motd[len], 1500-len,"<h4 align='center'><font size='1' color='#FF0000'><h4>Contact: urosh@in.com</h4></font>") 
	len += format(motd[len], 1500-len,"<center><h4><font color=^"white^"><B>----------------------------</B> </font></h4></center>")	
	
	show_motd(id, motd, "Anti Reklama v3.0") 
}

public AntiReklamaPrefix() 
{     
	remove_task(123) 
	read_argv(1, pCvar_Prefix, 20) 
}

public AccessDenied(id)
{
	client_cmd(id, "spk vox/denied.wav")
}

public menuItem( id )
{    
	if( !(get_user_flags( id ) & ACCESS ) )
	{
		client_print( id, print_chat, "[%s] %L", pCvar_Prefix, id, "NO_ACC_COM")	
		client_cmd(id, "spk vox/access.wav")
		set_task(0.6, "AccessDenied", id, _, _, "a", 1)
		return PLUGIN_CONTINUE
	}
	
	new status = (get_pcvar_num(pCvar_Status) == 1)
	ON_OFF = status
	
	formatex( pcvar_Menu, charsmax( pcvar_Menu ), "\rAnti Reklama - Menu")
	new menu = menu_create( pcvar_Menu, "menuAction" )
		
	formatex( pcvar_Menu, charsmax( pcvar_Menu ), "\d Status of plugin \r[\d%s\r]", (ON_OFF  & status) ? "ON" : "OFF")
	menu_additem( menu, pcvar_Menu, "0" )
		
	formatex( pcvar_Menu, charsmax( pcvar_Menu ), "\d Type of punishment \r[\d%i\r]", get_pcvar_num(pCvar_Punish))
	menu_additem( menu, pcvar_Menu, "1" )    
		
	menu_display( id, menu )
		
	return PLUGIN_CONTINUE
}

public menuAction( id, menu, item ) 
{ 
	if( item >= 0 )  
	{ 
		new access, callback, actionString[ 2 ]         
		menu_item_getinfo( menu, item, access, actionString, charsmax( actionString ), _, _, callback )         
		 
		new action = str_to_num( actionString ) 
		{ 
			switch( action ) 
			{ 
				case 0: 
				{ 
					formatex( pcvar_Menu, charsmax( pcvar_Menu ), "\rAnti Reklama - Menu")
					new menu = menu_create( pcvar_Menu, "menu1" )
						
					formatex( pcvar_Menu, charsmax( pcvar_Menu ), "\d Turn plugin ON")
					menu_additem( menu, pcvar_Menu, "0" )
						
					formatex( pcvar_Menu, charsmax( pcvar_Menu ), "\d Turn plugin OFF")
					menu_additem( menu, pcvar_Menu, "1" )    
						
					menu_display( id, menu ) 
				} 
			     
				case 1: 
				{ 
					formatex( pcvar_Menu, charsmax( pcvar_Menu ), "\rAnti Reklama - Menu")
					new menu = menu_create( pcvar_Menu, "menu2" )
						
					formatex( pcvar_Menu, charsmax( pcvar_Menu ), "\d Without Punishment")
					menu_additem( menu, pcvar_Menu, "1" )
					
					formatex( pcvar_Menu, charsmax( pcvar_Menu ), "\d Kill")
					menu_additem( menu, pcvar_Menu, "2" ) 				
						
					formatex( pcvar_Menu, charsmax( pcvar_Menu ), "\d Kick")
					menu_additem( menu, pcvar_Menu, "3" )    
	
					formatex( pcvar_Menu, charsmax( pcvar_Menu ), "\d Slap")
					menu_additem( menu, pcvar_Menu, "4" )   
					
					formatex( pcvar_Menu, charsmax( pcvar_Menu ), "\d Gag 5 min")
					menu_additem( menu, pcvar_Menu, "5" ) 				
					
					formatex( pcvar_Menu, charsmax( pcvar_Menu ), "\d Ban 5 min")
					menu_additem( menu, pcvar_Menu, "6" )	
					
					menu_display( id, menu )   
				} 
			} 
		}     
	}    
	menu_destroy( menu ) 
	return PLUGIN_HANDLED 
} 

public menu1( id, menu, item ) 
{ 
	if( item >= 0 )  
	{ 
		new access, callback, actionString[ 2 ]         
		menu_item_getinfo( menu, item, access, actionString, charsmax( actionString ), _, _, callback )         
		 
		new action = str_to_num( actionString ) 
		{ 
			switch( action ) 
			{ 
				case 0: 
				{ 
					server_cmd("antireklama_status 1")
					client_print( 0, print_chat, "[%s] Anti Reklama plugin is turned ON!", pCvar_Prefix)	
				} 
			     
				case 1: 
				{ 
					server_cmd("antireklama_status 0") 
					client_print( 0, print_chat, "[%s] Anti Reklama plugin is turned OFF!", pCvar_Prefix)
				} 
			} 
		}     
	}    
	menu_destroy( menu ) 
	set_task(0.1, "menuItem", id, _, _, "a", 1) 
	return PLUGIN_HANDLED 
} 

public menu2( id, menu, item ) 
{ 
	if( item >= 0 )  
	{ 
		new access, callback, actionString[ 2 ]         
		menu_item_getinfo( menu, item, access, actionString, charsmax( actionString ), _, _, callback )         
		 
		new action = str_to_num( actionString ) 
		{ 
			switch( action ) 
			{ 
				case 1: 
				{ 
					server_cmd("antireklama_punish %i", action)  
				} 
				case 2: 
				{ 
					server_cmd("antireklama_punish %i", action)  
				} 
				case 3: 
				{ 
					server_cmd("antireklama_punish %i", action)  
				} 	
				case 4: 
				{ 
					server_cmd("antireklama_punish %i", action)  
				} 
				case 5: 
				{ 
					server_cmd("antireklama_punish %i", action)  
				} 
				case 6: 
				{ 
					server_cmd("antireklama_punish %i", action)  
				} 		
			} 
			client_print( id, print_chat, "[%s] The changes are successfully saved!", pCvar_Prefix)
		}     
	}    
	menu_destroy( menu ) 
	set_task(0.1, "menuItem", id, _, _, "a", 1) 
	return PLUGIN_HANDLED 
}
/* AMXX-Studio Notes - DO NOT MODIFY BELOW HERE
*{\\ rtf1\\ ansi\\ deff0{\\ fonttbl{\\ f0\\ fnil Tahoma;}}\n\\ viewkind4\\ uc1\\ pard\\ lang1033\\ f0\\ fs16 \n\\ par }
*/
