#include <amxmodx>

#if AMXX_VERSION_NUM < 183
	#define engine_changelevel(%0) server_cmd("changelevel %s", %0)
#endif	

#define STARTTIME	03		// Время начала ночного режима. Тестировал только с 00 часов. Поддержка раннего времени есть, но не проверялось:)
#define ENDTIME		06		// Окончание ночного режима
#define MAP 		"de_dust2"	// Карта ночного режима
#define SUPPORT_PLUGINS			// Включает возможность подгрузить нужные плагины, которые нигде не юзаются:)

#define FILE_PLUGINS "addons/amxmodx/configs/plugins-night.ini"

public plugin_init()
{
#define VERSION "1.10"
	register_plugin("CFG NightMode", VERSION, "neygomon");
	register_cvar("cfg_nightmode", VERSION, FCVAR_SERVER | FCVAR_SPONLY);
#if defined SUPPORT_PLUGINS	
	register_srvcmd("night_load", "LoadPlugin");
#endif	
	CheckTime();
	set_task(60.0, "CheckTime", 5632, _, _, "b");
}

public CheckTime()
{
	static bool:bNight = false, sCurMap[32], CurHour; time(CurHour);
// Оптимизация :D	
	if(abs(STARTTIME - CurHour) > 1 && CurHour > ENDTIME) 
	{
		remove_task(5632);
		pause("ad");	
	}
#if STARTTIME > ENDTIME
	if(STARTTIME <= CurHour || CurHour < ENDTIME)
#else
	if(STARTTIME <= CurHour < ENDTIME)
#endif
	{	
		if(!sCurMap[0])
		{
			get_mapname(sCurMap, charsmax(sCurMap));
			if(!equal(sCurMap, MAP))
			{
				engine_changelevel(MAP);
				return;
			}	
		}	
		if(!bNight)
		{
			server_cmd("exec addons/amxmodx/configs/night_start.cfg");
			bNight = true;
		}	
		
	}	
	else if(bNight)
	{
		server_cmd("exec addons/amxmodx/configs/night_end.cfg");
#if defined SUPPORT_PLUGINS		
		unlink(FILE_PLUGINS);
#endif		
		bNight = false;
	}	
}
#if defined SUPPORT_PLUGINS
public LoadPlugin()
{
	static plugin[64]; read_argv(1, plugin, charsmax(plugin));
	if(plugin[0])
	{
		if(!strcmp(plugin[strlen(plugin) - 5], ".amxx") && !PluginInFile(plugin))
		{
			write_file(FILE_PLUGINS, plugin);
			if(!task_exists(765223)) set_task(1.3, "Restart", 765223); // применяем новые плагины
		}
		else log_amx("[%s] Incorrect plugin! Check Night configs!", plugin);
	}	
	return PLUGIN_HANDLED;
}

public Restart() server_cmd("restart");

bool:PluginInFile(plug[])
{
	new string[64], fp = fopen(FILE_PLUGINS, "rt");
	if(!fp) return false;
	while(!feof(fp))
	{
		fgets(fp, string, charsmax(string)); trim(string);
		if(!strcmp(string, plug)) return true;
	}
	fclose(fp);
	return false;
}
#endif