#include <amxmodx>
#include <amxmisc>

new const VERSION[] = "1.0";

//Если нужно использовать только reapi -- расскоментируйте строку.
#define REAPI

#if defined REAPI
    #include <reapi>
#else
    #include <fakemeta>
    #include <hamsandwich>
#endif

/* 
    * Путь до файла (игнорируя: addons/amxmodx/configs)
    * Создаётся автоматически.
*/
new const FILE[] = "MultiJump.ini"

enum _:XYZ {Float:X,Float:Y,Float:Z};

enum _:FILE_DATA
{
    szFlagAccess[64],
    g_iJumpNum[64]
};

enum _:PLAYER_DATA
{
    p_iFileJump,
    p_iJump
};

new
    gFileData[64][FILE_DATA],
    g_iFileLine,

    pPlayerData[33][PLAYER_DATA];

public plugin_init()
{
    register_plugin("Get Jumps",VERSION,"HaP[KOOZ]");

    #if defined REAPI
        RegisterHookChain(RG_CBasePlayer_Jump,"RG_CBasePlayerJumpPost");
        RegisterHookChain(RG_CBasePlayer_PreThink,"RG_CBasePlayerPreThink",false);
    #else
        RegisterHam(Ham_Player_Jump,"player","HamPlayerJumpPost");
        RegisterHam(Ham_Player_PreThink,"player","HamPlayerPreThink",false);
    #endif

    CheckFiles();
}

public client_putinserver(id)
{
    CheckUserAccess(id);
}

#if defined REAPI
    public RG_CBasePlayerJumpPost(const id)
#else
    public HamPlayerJumpPost(const id)
#endif
    {
        if(!is_user_alive(id))
            #if defined REAPI
                return HC_CONTINUE;
            #else
                return HAM_IGNORED;
            #endif

        static BitBut,BitOldBut,iFlags;

        #if defined REAPI
            iFlags = get_entvar(id,var_flags);
        #else
            iFlags = pev(id,pev_flags);
        #endif

        #if defined REAPI
            BitBut = get_entvar(id,var_button);
            BitOldBut = get_entvar(id,var_oldbuttons);
        #else
            BitBut = pev(id,pev_button);
            BitOldBut = pev(id,pev_oldbuttons);
        #endif

        if(BitBut & IN_JUMP && !(BitOldBut & IN_JUMP) && pPlayerData[id][p_iJump] > 0 && !(iFlags & FL_ONGROUND))
        {
            static Float:Vec[XYZ];
            #if defined REAPI
                get_entvar(id,var_velocity,Vec);
            #else
                pev(id,pev_velocity,Vec);
            #endif

            Vec[Z] = random_float(265.0,285.0);

            #if defined REAPI
                set_entvar(id,var_velocity,Vec);
            #else
                set_pev(id,pev_velocity,Vec);
            #endif
            pPlayerData[id][p_iJump]--;

            #if defined REAPI
                return HC_CONTINUE;
            #else
                return HAM_IGNORED;
            #endif
        }

        #if defined REAPI
            return HC_CONTINUE;
        #else
            return HAM_IGNORED;
        #endif
    }
#if defined REAPI
    public RG_CBasePlayerPreThink(const id)
#else
    public HamPlayerPreThink(const id)
#endif
    {
        if(!is_user_alive(id))
            #if defined REAPI
                return HC_CONTINUE;
            #else
                return HAM_IGNORED;
            #endif

        static iFlags;

        #if defined REAPI
            iFlags = get_entvar(id,var_flags);
        #else
            iFlags = pev(id,pev_flags);
        #endif

        if(pPlayerData[id][p_iFileJump] != 0 && iFlags & FL_ONGROUND)
            if(pPlayerData[id][p_iFileJump] != pPlayerData[id][p_iJump])
                pPlayerData[id][p_iJump] = pPlayerData[id][p_iFileJump];
            
        #if defined REAPI
            return HC_CONTINUE;
        #else
            return HAM_IGNORED;
        #endif
    }

stock CheckUserAccess(const id)
{
    for(new iNum;iNum<=g_iFileLine;iNum++)
        if(get_user_flags(id) & read_flags(gFileData[iNum][szFlagAccess]))
            pPlayerData[id][p_iFileJump] = str_to_num(gFileData[iNum][g_iJumpNum]);
}

stock CheckFiles()
{
    new szConfig[256],szFile[256];

    get_configsdir(szConfig,charsmax(szConfig));
    formatex(szFile,charsmax(szFile),"%s/%s",szConfig,FILE);

    if(!file_exists(szFile))
    {
        new szFileView[256];
        formatex(szFileView,charsmax(szFileView),
            ";  *^"Флаг^" ^"Кол-во прыжков^"^n\
            ^"a^" ^"3^""
        );
        write_file(szFile,szFileView,-1);
    }

    LoadFileSettings(szFile);
}

stock LoadFileSettings(szFile[256])
{
    new szData[256],f;

    if(!(f=fopen(szFile,"rt")))
        return set_fail_state("Не удалось загрузить файл [%s]",szFile);
    
    g_iFileLine = -1;
    while(!feof(f))
    {
        fgets(f,szData,charsmax(szData));
        trim(szData);

        if(szData[0] == '"')
        {
            g_iFileLine++;
            parse(szData,
                gFileData[g_iFileLine][szFlagAccess],charsmax(gFileData),
                gFileData[g_iFileLine][g_iJumpNum],charsmax(gFileData)
            );
        }
    }
    fclose(f);
    return PLUGIN_HANDLED;
}