/*
	Плагин возрождает первых игроков если они умерли очень рано (аналог скальпеля)
*/

#define VALID_PLAYER(%1)	(1 <= %1 <= MaxClients)

#include <amxmodx>
#include <reapi>

new g_iCvarMinPlayers,
	g_iCvarFirstRound,
	g_iCvarDomination,
	g_iCvarPlayers[TeamName],
	g_iCvarAddAccount,
	g_iCvarPreventSuicide,
	g_iCvarPreventTwice,
	
	Float:g_flCvarTime,
	Float:g_flCvarProtectionTime;


new g_iRespawnCount[TeamName];

public plugin_init()
{
	register_plugin("FirstPlayersRespawn", "1.0.0", "Emma Jule");
	
	RegisterHookChain(RG_CBasePlayer_Killed, "CBasePlayer_Killed", true);
	RegisterHookChain(RG_CSGameRules_RestartRound, "CSGameRules_RestartRound", true);
	
	bind_pcvar_float(create_cvar("fpr_time", "30.0", .description = "Время в секундах до которого игроки смогут возродится"), g_flCvarTime);
	bind_pcvar_num(create_cvar("fpr_firstround", "1", .description = "Устанавливать в первом раунде при возрождении стандартное количество денег"), g_iCvarFirstRound);
	bind_pcvar_num(create_cvar("fpr_minplayers", "10", .description = "Минимальное количество игроков в котором НЕ действует возрождение"), g_iCvarMinPlayers);
	bind_pcvar_num(create_cvar("fpr_domination", "3", .description = "Если команда доминирует (выигрывает Х раундов подряд) не даем им воскрешатся"), g_iCvarDomination);
	bind_pcvar_num(create_cvar("fpr_players_t", "2", .description = "Сколько игроков может возродится за раунд у Т"), g_iCvarPlayers[TEAM_TERRORIST]);
	bind_pcvar_num(create_cvar("fpr_players_сt", "2", .description = "Сколько игроков может возродится за раунд у КТ"), g_iCvarPlayers[TEAM_CT]);
	bind_pcvar_num(create_cvar("fpr_prevent_suicide", "1", .description = "Возрождать игрока только если он умер от игрока"), g_iCvarPreventSuicide);
	bind_pcvar_num(create_cvar("fpr_prevent_double", "1", .description = "Не возрождать игрока который уже воскрешался в этом раунде"), g_iCvarPreventTwice);
	bind_pcvar_float(create_cvar("fpr_protection", "3.0", .description = "Время в секундах, после возрождения, нельзя убить игрока"), g_flCvarProtectionTime);
	bind_pcvar_num(create_cvar("fpr_money", "650", .description = "Сколько денег давать при возрождении?"), g_iCvarAddAccount);
	
	AutoExecConfig(.name = "FirstPlayersRespawn");
}

public CSGameRules_RestartRound()
{
	g_iRespawnCount[TEAM_TERRORIST] = 0;
	g_iRespawnCount[TEAM_CT] = 0;
}

public CBasePlayer_Killed(const id, const attacker)
{
	new Float:flCurTime = get_gametime();
	
	if (flCurTime - Float: get_member_game(m_fRoundStartTime) > g_flCvarTime)
		return;
	
	if (g_iCvarPreventSuicide && (id == attacker || !VALID_PLAYER(attacker)))
		return;
	
	if (g_iCvarPreventTwice && get_member(id, m_iNumSpawns) > 1)
		return;
	
	if (get_member_game(m_iNumSpawnableTerrorist) + get_member_game(m_iNumSpawnableCT) < g_iCvarMinPlayers)
		return;
	
	new TeamName:team = get_member(id, m_iTeam);
	if (g_iCvarDomination > 0 && team == rg_get_team_wins_row(g_iCvarDomination))
		return;
	
	if (++g_iRespawnCount[team] > g_iCvarPlayers[team])
		return;
	
	set_member(id, m_flRespawnPending, flCurTime + 0.1);
	set_member(id, m_flSpawnProtectionEndTime, flCurTime + g_flCvarProtectionTime);
	
	if (g_iCvarFirstRound && get_member_game(m_iTotalRoundsPlayed) == 0)
	{
		static mp_startmoney;
		if (mp_startmoney || (mp_startmoney = get_cvar_pointer("mp_startmoney")))
			rg_add_account(id, get_pcvar_num(mp_startmoney), AS_SET, false);
	}
	else
		rg_add_account(id, g_iCvarAddAccount, .bTrackChange = false);
	
	client_print_color(id, print_team_default, "^4* ^3первые %i возрождаются", g_iCvarPlayers[team]);
}

stock TeamName:rg_get_team_wins_row(const iWins)
{
	new TeamName:team = TEAM_UNASSIGNED;
	new iNumConsecutiveCTLoses = get_member_game(m_iNumConsecutiveCTLoses);
	new iNumConsecutiveTerroristLoses = get_member_game(m_iNumConsecutiveTerroristLoses);
	
	if (iNumConsecutiveCTLoses > 0)
		team = TEAM_TERRORIST;
	else if (iNumConsecutiveTerroristLoses > 0)
		team = TEAM_CT;
	
	if (abs(iNumConsecutiveCTLoses + iNumConsecutiveTerroristLoses) < iWins)
		team = TEAM_UNASSIGNED;
	
	return team;
}
