public stock const AUTHOR[] = "Emma Jule";
public stock const VERSION[] = "1.0.0";

#include <amxmodx>
#include <fakemeta>
#include <hamsandwich>
#include <reapi>

new const CORPSE_CLASSNAME[] = "info_corpse";

enum _:CVARS
{
	ACCESS[32],
	Float:DURATION,
	USE,
	Float:ROUND_TIME,
	MAX,
	SHOOT,
	Float:SPEED,
	Float:DISTANCE,
	SPAWN_MODE,
	OBSERVER,
	Float:HEALTH,
	Float:BONUS_HEALTH,
	MONEY,
	FRAG,
	GUN[24],
	BAR,
	BOMB,
	DUEL,
	VIP,
	DIFF,
	Float:ALPHA,
	NOTIFICATION,
	ONLY_KNIFE,
	SAMPLE[MAX_RESOURCE_PATH_LENGTH],
	
};	new CVAR[CVARS];

enum _:FORWARDS
{
	REVIVE_RETURN,
	REVIVE_BEGIN,
	REVIVE_END,

};	new FORWARD[FORWARDS];

new g_iPlayerCorpse[MAX_PLAYERS + 1];

public plugin_precache()
{
	register_plugin("Revive Players", VERSION, AUTHOR);
	
	CreateCvars();
}

public plugin_init()
{
	if (register_dictionary("revive_teammates.txt") == 0)
		server_print("[Revive Teammates] Файл ^"revive_teammates.txt^" отсутствует..");
	
	register_message(get_user_msgid("ClCorpse"), "MsgHookClCorpse");
	
	register_event("TeamInfo", "Event_TeamInfo", "a", "1>0", "2=SPECTATOR");
	
	RegisterHookChain(RG_CBasePlayer_Spawn, "CBasePlayer_Spawn", true);
	RegisterHookChain(RG_CSGameRules_CleanUpMap, "CSGameRules_CleanUpMap", true);
	
	if (CVAR[SPEED])
		RegisterHookChain(RG_CBasePlayer_ResetMaxSpeed, "CBasePlayer_ResetMaxSpeed", true);
	
	RegisterHam(Ham_ObjectCaps, "info_target", "fw_ObjectCaps", false);
	
	if (CVAR[ONLY_KNIFE])
		RegisterHam(Ham_Item_CanHolster, "weapon_knife", "fw_Item_CanHolster", false);
}

public client_disconnected(id)
{
	CorpseRemove(id);
}

public Event_TeamInfo()
{
	CorpseRemove(read_data(1));
}

public CBasePlayer_Spawn(const id)
{
	CorpseRemove(id);
}

public CBasePlayer_ResetMaxSpeed(const id)
{
	if (~get_entvar(id, var_iuser3) & PLAYER_PREVENT_CLIMB)
		return;
	
	set_entvar(id, var_maxspeed, CVAR[SPEED]);
}

public CSGameRules_CleanUpMap()
{
	new id = rg_find_ent_by_class(NULLENT, CORPSE_CLASSNAME);
	
	while (id > 0)
	{
		CorpseRemove(get_entvar(id, var_owner));
		
		id = rg_find_ent_by_class(id, CORPSE_CLASSNAME);
	}
}

public fw_ObjectCaps(id)
{
	if (!FClassnameIs(id, CORPSE_CLASSNAME))
		return HAM_IGNORED;
	
	SetHamReturnInteger(FCAP_ONOFF_USE);
	return HAM_OVERRIDE;
}

public fw_Item_CanHolster(iWeapon)
{
	new pPlayer = get_member(iWeapon, m_pPlayer);
	
	if (~get_entvar(pPlayer, var_iuser3) & PLAYER_PREVENT_CLIMB)
		return HAM_IGNORED;
	
	SetHamReturnInteger(false);
	return HAM_OVERRIDE;
}

@corpse_use(id, activator, caller, USE_TYPE:type, Float:value)
{
	if (get_member_game(m_bRoundTerminating))
		return;
	
	if (value == 0.0)
		return;
	
	if (is_nullent(id))
		return;
	
	if (activator != caller)
		return;
	
	if (!ExecuteHam(Ham_IsPlayer, activator))
		return;
	
	// if (get_entvar(id, var_movetype) == MOVETYPE_FLY)
		// return;
	
	if (get_entvar(activator, var_waterlevel) > 1)
		return;
	
	if (get_member(activator, m_iTeam) != get_entvar(id, var_team))
		return;
	
	if (~get_user_flags(activator) & read_flags(CVAR[ACCESS]))
		return;
	
	static Float:flCurTime;
	flCurTime = get_gametime();
	
	if (flCurTime - Float:get_member_game(m_fRoundStartTime) < CVAR[ROUND_TIME])
	{
		client_print_color(activator, print_team_red, "%l %l", "RT_PREFIX", "RT_ROUND_TIME");
		return;
	}
	
	if (CVAR[DUEL] && rg_is_1v1())
	{
		client_print_color(activator, print_team_red, "%l %l", "RT_PREFIX", "RT_1VS1");
		return;
	}
	
	if (CVAR[BOMB] && rg_is_bomb_planted())
	{
		client_print_color(activator, print_team_red, "%l %l", "RT_PREFIX", "RT_BOMB_PLANTED");
		return;
	}
	
	if (CVAR[VIP] && get_member(activator, m_bIsVIP))
	{
		client_print_color(activator, print_team_red, "%l %l", "RT_PREFIX", "RT_VIP");
		return;
	}
	
	if (get_member(activator, m_iTeam) == rg_get_team_dominate())
	{
		client_print_color(activator, print_team_red, "%l %l", "RT_PREFIX", "RT_TEAM_DOMINATE");
		return;
	}
	
	if (get_entvar(id, var_iuser1) > 0)
	{
		client_print_color(activator, print_team_red, "%l %l", "RT_PREFIX", "RT_ALREADY_REVIVE", get_entvar(id, var_iuser1));
		return;
	}
	
	if (get_member((caller = get_entvar(id, var_owner)), m_iNumSpawns) > CVAR[MAX])
	{
		client_print_color(activator, print_team_red, "%l %l", "RT_PREFIX", "RT_MAX");
		return;
	}
	
	// @hack: speed rules
	new Float:vecVelocity[3];
	get_entvar(activator, var_velocity, vecVelocity);
	if (vector_length(vecVelocity) > 250.0)
		return;
	
	ExecuteForward(FORWARD[REVIVE_BEGIN], FORWARD[REVIVE_RETURN], caller, activator);
	
	if (FORWARD[REVIVE_RETURN] > PLUGIN_CONTINUE)
		return;
	
	if (CVAR[ONLY_KNIFE])
		if (!rg_switch_weapon(activator, get_member(activator, m_rgpPlayerItems, KNIFE_SLOT)))
			return;
	
	// это просто фишка
	set_entvar(activator, var_iuser3, get_entvar(activator, var_iuser3) | PLAYER_PREVENT_CLIMB);
	
	set_entvar(id, var_iuser1, activator);
	set_entvar(id, var_fuser1, flCurTime + CVAR[DURATION]);
	set_entvar(id, var_nextthink, flCurTime + 0.2);
	
	if (CVAR[ALPHA])
		rg_set_rendering(id, .mode = kRenderTransAlpha, .flColor = Float:{ 200.0, 200.0, 200.0 }, .iAmount = CVAR[ALPHA]);
	
	// Уведомления
	{
		set_dhudmessage(0, 160, 30, -1.0, 0.84, 2, 3.0, 2.0, 0.03, 0.4);
		show_dhudmessage(caller, "%l", "RT_REVIVING", activator);
		
		set_dhudmessage(0, 160, 30, -1.0, 0.76, 2, 3.0, 2.0, 0.03, 0.4);
		show_dhudmessage(activator, "%l", "RT_REVIVING2", caller, CVAR[DURATION]);
	}
	
	if (CVAR[OBSERVER])
	{
		// set_entvar(caller, var_iuser1, OBS_IN_EYE);
		rg_internal_cmd(caller, "specmode", "4");
		set_entvar(caller, var_iuser2, activator);
		
		set_member(caller, m_hObserverTarget, activator);
		set_member(caller, m_flNextObserverInput, flCurTime + 1.6);
	}
	
	if (CVAR[SHOOT])
		set_entvar(activator, var_iuser3, get_entvar(activator, var_iuser3) & ~PLAYER_CAN_SHOOT);
		// set_member(activator, m_bIsDefusing, true);
	
	if (CVAR[SPEED])
		rg_reset_maxspeed(activator);
	
	if (CVAR[BAR])
		rg_send_bartime(activator, floatround(CVAR[DURATION]), bool:(CVAR[BAR] == 1));
	
	for (new i; i < 3; i++)
		vecVelocity[i] *= 0.25;
	
	set_entvar(activator, var_velocity, vecVelocity);
}

@corpse_think(id)
{
	if (is_nullent(id))
		return;
	
	new bool:bIsStop = false;
	new activator = get_entvar(id, var_iuser1);
	
	if (get_entvar(activator, var_deadflag) != DEAD_NO)
		bIsStop = true;
	
	if (CVAR[USE] && ~get_entvar(activator, var_button) & IN_USE)
		bIsStop = true;
	
	if (CVAR[MONEY] < 0) {
		if (get_member(activator, m_iAccount) < -CVAR[MONEY]) {
			client_print_color(activator, print_team_red, "%l %l", "RT_PREFIX", "RT_NO_MONEY");
			bIsStop = true;
		}
	}
	
	static Float:flOrigin[3], Float:vecOrigin[3];
	get_entvar(id, var_origin, vecOrigin);
	get_entvar(activator, var_origin, flOrigin);
	if (vector_distance(flOrigin, vecOrigin) > CVAR[DISTANCE]) {
		bIsStop = true;
	}
	
	static Float:flCurTime;
	flCurTime = get_entvar(id, var_fuser1);
	
	if ((flCurTime != 0.0 && get_gametime() >= flCurTime))
	{
		new player = get_entvar(id, var_owner);
		
		set_member(player, m_bNotKilled, true);
		
		rg_round_respawn(player);
		
		// Возвращаем на место смерти
		if (CVAR[SPAWN_MODE])
		{
			engfunc(EngFunc_SetOrigin, player, vecOrigin);
			
			set_entvar(player, var_flags, get_entvar(player, var_flags) | FL_DUCKING);
			set_entvar(player, var_view_ofs, Float:{ 0.0, 0.0, 12.0 });
		}
		
		set_entvar(player, var_health, CVAR[HEALTH]);
		
		if (CVAR[GUN][0])
		{
			new pWeapon = rg_give_item(player, fmt("weapon_%s", CVAR[GUN]));
			
			if (!is_nullent(pWeapon))
			{
				new WeaponIdType:iId = get_member(pWeapon, m_iId);

				set_member(player, m_rgAmmo, rg_get_weapon_info(iId, WI_MAX_ROUNDS), rg_get_weapon_info(iId, WI_AMMO_TYPE));
			}
		}
		else
			rg_give_default_items(player);
		
		rg_add_account(activator, CVAR[MONEY]);
		
		if (CVAR[FRAG])
			ExecuteHamB(Ham_AddPoints, activator, CVAR[FRAG], true);
		
		if (CVAR[BONUS_HEALTH])
			ExecuteHamB(Ham_TakeHealth, activator, CVAR[BONUS_HEALTH], DMG_GENERIC);
		
		switch (CVAR[NOTIFICATION])
		{
			case 1: client_print_color(0, player, "%l %l", "RT_PREFIX", "RT_NOTIFICATION", activator, player);
			
			case 2:
			{
				for (new i; i < MaxClients; ++i)
				{
					if (!is_user_connected(i))
						continue;
					
					if (rg_is_player_can_takedamage(player, i))
						continue;
					
					client_print_color(i, player, "%l %l", "RT_PREFIX", "RT_NOTIFICATION", activator, player);
				}
			}
		}
		
		if (CVAR[SAMPLE][0])
			rh_emit_sound2(activator, 0, CHAN_BODY, CVAR[SAMPLE]);
		
		ExecuteForward(FORWARD[REVIVE_END], _, player, activator);
		
		CorpseRemove(player);
	}
	
	if (bIsStop)
	{
		set_entvar(id, var_iuser1, 0);
		set_entvar(id, var_fuser1, 0.0);
		set_entvar(id, var_nextthink, 0.0);
		
		rg_set_rendering(id);
		
		ResetRestrictions(activator);
	}
	else
		set_entvar(id, var_nextthink, get_gametime() + 0.2);
}

ResetRestrictions(pActivator)
{
	if (pActivator <= 0)
		return;
	
	set_entvar(pActivator, var_iuser3, get_entvar(pActivator, var_iuser3) & ~PLAYER_PREVENT_CLIMB);
	
	if (CVAR[SHOOT])
		set_entvar(pActivator, var_iuser3, get_entvar(pActivator, var_iuser3) | PLAYER_CAN_SHOOT);
		// set_member(pActivator, m_bIsDefusing, false);
	
	if (CVAR[SPEED])
		rg_reset_maxspeed(pActivator);
	
	if (CVAR[BAR])
		rg_send_bartime(pActivator, 0);
}

public MsgHookClCorpse()
{
	new id = rg_create_entity("info_target");
	
	if (is_nullent(id))
		return PLUGIN_CONTINUE;
	
	// владелец тела
	new pPlayer = get_msg_arg_int(12);
	
	new Float:vecOrigin[3];
	new Float:vecAngles[3];
	new szModel[32];
	
	g_iPlayerCorpse[pPlayer] = id;
	
	for (new i; i < 3; i++)
	{
		vecOrigin[i] = float(get_msg_arg_int(2 + i)) / 128.0;
		vecAngles[i] = get_msg_arg_float(5 + i);
	}
	
	get_msg_arg_string(1, szModel, charsmax(szModel));
	
	engfunc(EngFunc_SetModel, id, fmt("models/player/%s/%s.mdl", szModel, szModel));
	engfunc(EngFunc_SetSize, id, Float:{ -26.0, -26.0, 0.0 }, Float:{ 26.0, 26.0, 24.0 });
	engfunc(EngFunc_SetOrigin, id, vecOrigin);
	// engfunc(EngFunc_DropToFloor, id);
	
	set_entvar(id, var_classname, CORPSE_CLASSNAME);
	set_entvar(id, var_angles, vecAngles);
	set_entvar(id, var_body, get_msg_arg_int(10));
	set_entvar(id, var_framerate, 1.0);
	set_entvar(id, var_animtime, 0.0);
	set_entvar(id, var_sequence, get_msg_arg_int(9));
	set_entvar(id, var_owner, pPlayer);
	set_entvar(id, var_team, get_msg_arg_int(11));
	
	// custom values
	set_entvar(id, var_iuser1, 0);
	set_entvar(id, var_fuser1, 0.0);
	
	// корень
	{
		SetUse(id, "@corpse_use");
		SetThink(id, "@corpse_think");
	}
	
	return PLUGIN_HANDLED;
}

CorpseRemove(pPlayer)
{
	new id = g_iPlayerCorpse[pPlayer];
	
	g_iPlayerCorpse[pPlayer] = 0;
	
	if ((any:is_nullent(id) & ((-1) / 2)) == 0)
	{
		set_entvar(id, var_flags, FL_KILLME);
		
		ResetRestrictions(get_entvar(id, var_iuser1));
	}
}

CreateCvars()
{
	// $ddir/addons/amxmodx/configs/plugins/revive_teammates.cfg
	// файл создастся сам автоматически с вполне оптимальными настройками
	{
		bind_pcvar_string(create_cvar("rt_access_flag", "", .description = "Флаг(и) доступа администратора [^"^" - доступно всем]"), CVAR[ACCESS], charsmax(CVAR[ACCESS]));
		bind_pcvar_float(create_cvar("rt_duration", "5.0", .description = "Время через которое воскреснит союзник [в секундах]", .has_min = true, .min_val = 1.0, .has_max = true, .max_val = 10.0), CVAR[DURATION]);	
		bind_pcvar_num(create_cvar("rt_use", "1", .description = "Метод клавиши^n0 - просто нажать на клавишу^n1 - нужно удерживать клавишу", .has_max = true, .max_val = 1.0), CVAR[USE]);
		bind_pcvar_float(create_cvar("rt_round_time", "15.0", .description = "Это будет доступно через N сек. от начала раунда [0 - выкл]", .has_max = true, .max_val = 30.0), CVAR[ROUND_TIME]);
		bind_pcvar_num(create_cvar("rt_max_spawns", "3", .description = "Максимальное кол-во раз сколько может воскреснуть игрок за раунд"), CVAR[MAX]);
		bind_pcvar_num(create_cvar("rt_cant_shoot", "0", .description = "Заблокировать стрельбу во время события?", .has_max = true, .max_val = 1.0), CVAR[SHOOT]);
		bind_pcvar_float(create_cvar("rt_speed", "150.0", .description = "Скорость игрока во время события [0 - будет неизменной]", .has_max = true, .max_val = 250.0), CVAR[SPEED]);
		bind_pcvar_float(create_cvar("rt_distance", "128.0", .description = "Максимальная допустимая дистанция", .has_min = true, .min_val = 64.0, .has_max = true, .max_val = 350.0), CVAR[DISTANCE]);
		bind_pcvar_num(create_cvar("rt_spawn_mode", "1", .description = "Режим возрождения^n^n0. возрождается на базе^n1. возрождается там где умер", .has_max = true, .max_val = 1.0), CVAR[SPAWN_MODE]);
		bind_pcvar_num(create_cvar("rt_force_camera", "1", .description = "Автоматически переключать камеру игрока которого возрождают на того кто его возрождает", .has_max = true, .max_val = 1.0), CVAR[OBSERVER]);
		bind_pcvar_num(create_cvar("rt_money", "-500", .description = "Сколько добовляем денег тому кто поднял тиммейта^nИспользуйте отрицательное значение чтобы вычитать"), CVAR[MONEY]);
		bind_pcvar_num(create_cvar("rt_frag", "1", .description = "Сколько даем фрагов тому кто поднял тиммейта?"), CVAR[FRAG]);
		bind_pcvar_float(create_cvar("rt_bonus_health", "5.0", .description = "Сколько добовляем HP тому кто поднял тиммейта"), CVAR[BONUS_HEALTH]);
		bind_pcvar_float(create_cvar("rt_health", "50.0", .description = "Здоровье воскрешенного игрока", .has_min = true, .min_val = 1.0, .has_max = true, .max_val = 255.0), CVAR[HEALTH]);
		bind_pcvar_string(create_cvar("rt_weapon", "deagle", .description = "Оружие воскрешенного игрока [^"^" - используем квар mp_default_primary & mp_default_secondary]"), CVAR[GUN], charsmax(CVAR[GUN]));
		bind_pcvar_num(create_cvar("rt_bar", "1", .description = "Линия прогресса^n^n0. выкл^n1. вкл^n2. вкл (но те кто наблюдают за игроком не увидят это)", .has_max = true, .max_val = 2.0), CVAR[BAR]);
		bind_pcvar_num(create_cvar("rt_bomb", "0", .description = "Блокируем возрождения когда бобма установленна?", .has_max = true, .max_val = 1.0), CVAR[BOMB]);
		bind_pcvar_num(create_cvar("rt_1v1", "0", .description = "Блокируем возрождения когда остались 1vs1?", .has_max = true, .max_val = 1.0), CVAR[DUEL]);
		bind_pcvar_num(create_cvar("rt_vip", "1", .description = "Запрет VIP игроку воскрешать союзников? (на as_* картах)", .has_max = true, .max_val = 1.0), CVAR[VIP]);
		bind_pcvar_num(create_cvar("rt_win_diff", "20", .description = "Если разница между победами команд превышает это значение, то мы блокируем воскрешения?", .has_min = true, .min_val = 3.0), CVAR[DIFF]);
		bind_pcvar_num(create_cvar("rt_notifications", "2", .description = "Режим уведомлений^n^n0. выкл^n1. видно всем^n2. только команде", .has_max = true, .max_val = 2.0), CVAR[NOTIFICATION]);
		bind_pcvar_float(create_cvar("rt_alpha", "150.0", .description = "Степень прозрачности свечения трупа [^"0^" - выключить свечение]", .has_max = true, .max_val = 255.0), CVAR[ALPHA]);
		bind_pcvar_num(create_cvar("rt_only_knife", "0", .description = "Можно возрождать только с ножом в руке", .has_max = true, .max_val = 1.0), CVAR[ONLY_KNIFE]);
		bind_pcvar_string(create_cvar("rt_revived_sample", "x/x_recharge3.wav", .description = "Звук при завершении возрождения [^"^" - нет]"), CVAR[SAMPLE], charsmax(CVAR[SAMPLE]));
	}
	
	if (!file_exists(CVAR[SAMPLE]))
		CVAR[SAMPLE][0] = EOS;
	else
		precache_sound(CVAR[SAMPLE]);
	
	if (!CheckIsCvarPossible(CVAR[GUN]))
		CVAR[GUN][0] = EOS;
	
/*
	new aData[4][4];
	if (parse(CVAR[RENDER], aData[0], 3, aData[1], 3, aData[2], 3, aData[3], 3) < 4)
	{
		#pragma unused flRenderColor, iRenderAlpha
		
		CVAR[RENDER][0] = EOS;
	}
	else
	{
		for (new i = 0; i < 3; i++)
			flRenderColor[i] = str_to_float(aData[i]);
		
		flRenderAlpha = str_to_float(aData[3]);
	}
*/
	
	FORWARD[REVIVE_BEGIN] = CreateMultiForward("rt_start_revive", ET_CONTINUE, FP_CELL, FP_CELL);
	FORWARD[REVIVE_END] = CreateMultiForward("rt_revived", ET_IGNORE, FP_CELL, FP_CELL);
	
	AutoExecConfig(.name = "revive_teammates");
	
	// register_cvar("revive_teammates", VERSION, FCVAR_SERVER | FCVAR_SPONLY);
}

CheckIsCvarPossible(const name[])
{
	if (!name[0])
		return true;
	
	// ConnorMcLeod
	static const szWeapons[][] = { "p228", "scout", "xm1014", "mac10", "aug", "elite",
		"fiveseven", "ump45", "sg550", "galil", "famas", "usp", "glock18", "awp",
		"mp5navy", "m249", "m3", "m4a1", "tmp", "g3sg1", "deagle", "sg552", "ak47", "p90",
		"hegrenade", "smokegrenade", "flashbang", "knife" };
	
	for (new i = 0; i < sizeof(szWeapons); i++)
		if (strcmp(szWeapons[i], name) == 0)
			return true;
	
	return false;
}

stock bool:rg_is_1v1()
{
	new alive_t, alive_ct;
	rg_initialize_player_counts(alive_t, alive_ct, _, _);
	
	return bool:(alive_t == 1 && alive_ct == 1);
}

stock TeamName:rg_get_team_dominate(&diff = 0)
{
	diff = get_member_game(m_iNumTerroristWins) - get_member_game(m_iNumCTWins);
   
	return abs(diff) < CVAR[DIFF] ? TEAM_UNASSIGNED : diff ? TEAM_TERRORIST : TEAM_CT;
}

stock rg_set_rendering(const id, const fx = kRenderFxNone, const mode = kRenderNormal, const Float:flColor[] = NULL_VECTOR, const Float:iAmount = 0.0)
{
	set_entvar(id, var_renderfx, fx);
	set_entvar(id, var_rendermode, mode);
	set_entvar(id, var_rendercolor, flColor);
	set_entvar(id, var_renderamt, iAmount);
}