$('#send').ajaxForm({
	dataType: 'json',
	success: function(data)
	{
		$.each(data, function(i, val)
		{
			if(i == 'e')
				bootbox.dialog('<h3 class="red">Ошибка</h3>'+val,
					[{
						"label" : "OK",
						"class" : "btn-small btn-primary",
					}]
				);

			if(i == 's')
			{
				chat_sound('send');
				$('#text').val('');
				chat_dialog(false);
			}
		});

		loading(0);

		return false;
	}
});

function chat_msg_send()
{
	if($('#text').val() == '')
	{
		chat_sound('err');
		return false;
	}

	loading(1);

	return true;
}

function chat_msg_del(id, user)
{
	bootbox.dialog('<h3 class="red">Выберете операцию</h3>',
		[{
			"label" : "Удалить выбранное сообщение",
			"class" : "btn-small btn-primary",
			callback: function(){
				chat_msg_del_go(id, '')
			}
		},{
			"label" : "Удалить все сообщения отправителя",
			"class" : "btn-small btn-primary",
			callback: function(){
				chat_msg_del_go(user, '/go')
			}
		},{
			"label" : "Отмена",
			"class" : "btn-small btn-primary"
		}]
	);

	return false;
}

function chat_msg_del_go(id, go)
{
	$.getJSON(home+'chat/section/delete/id/'+id+go, function(data)
	{
		$.each(data, function(i, val)
		{
			if(i == 'e')
				bootbox.dialog('<h3 class="red">Ошибка</h3>'+val,
					[{
						"label" : "OK",
						"class" : "btn-small btn-primary",
					}]
				);

			if(i == 's')
				chat_dialog(false);
		});
	});

	return false;
}

function chat_dialog(go)
{
	var dialog_form = document.getElementById('dialog');

	$.get(home+'chat/section/dialog', function(data){$('#dialog').html(data)});

	if(chat_scroll_ativate)
		setTimeout(function() {dialog_form.scrollTop = dialog_form.scrollHeight;}, 300);

	if(chat_notice_ativate)
		chat_dialog_info();

	if(go)
		setTimeout(function() {chat_dialog(go)}, 4000);
}

function chat_dialog_info(go)
{
	$.get(home+'chat/section/dialog/go', function(data){
		if(data != chat_dialog_id && data != '')
		{
			chat_dialog_id = data;
			chat_sound('notice')
		}
	});
}

function chat_reply(login)
{
	$('#text').val(login+', '+$('#text').val());

	return false;
}

function chat_scroll_change()
{
	if(chat_scroll_ativate)
	{
		chat_scroll_ativate = false;
		$('#chat_scroll').html('включить скроллинг');
	}else{
		chat_scroll_ativate = true;
		$('#chat_scroll').html('отключить скроллинг');
	}
}

function chat_notice_change()
{
	if(chat_notice_ativate)
	{
		chat_notice_ativate = false;
		$('#chat_notice').html('включить уведомления');
	}else{
		chat_notice_ativate = true;
		$('#chat_notice').html('отключить уведомления');
	}
}

function chat_sound_change()
{
	if(chat_sound_ativate)
	{
		chat_sound_ativate = false;
		$('#chat_sound').html('включить звуки');
	}else{
		chat_sound_ativate = true;
		$('#chat_sound').html('отключить звуки');
	}
}

function chat_emoji(emoji)
{
	form = document.getElementById('text');
	begin = form.value.substr(0, form.selectionStart);
	end = form.value.substr(form.selectionEnd);
	var text = form.firstChild;
	form.value = begin+'[emoji_'+emoji+']'+end;
	selPos = '[emoji_'+emoji+']'.length+begin.length;
	form.setSelectionRange(begin.length, selPos);

	return false;
}

function chat_sound(track)
{
	if(!chat_sound_ativate)
		return false;

	var audio = new Audio();
	audio.preload = 'auto';
	audio.src = '/template/sections/chat/sound/chat_'+track+'.wav';
	audio.play();
}