#include <amxmodx>
#include <amxmisc>

#define PLUGIN "HudMessagesManager"
#define VERSION "1.0"
#define AUTHOR "Arwel"

#define DHUD /*    HUD*/

#if defined DHUD
	#include <dhudmessage>
#endif

#define CFG_FILE "hud_messages.ini"

#define MAX_CHARS 128 /*   */
#define TIME_TO_SEND 60.0 /*  */
#define HUD_EFF 0 /*  */
#define HUD_FIX_TIME 0.5 /*         ;    DHUD*/ 
#define HUD_FADE_IN_TIME 0.5 /*  */
#define HUD_FADE_OUT_TIME 0.5 /*  */

new Array:g_aMessage
new Array:g_aColor
new Array:g_aTime
new Array:g_aPosition

new g_MsgId, g_ArraySize

public plugin_init() 
{
	register_plugin(PLUGIN, VERSION, AUTHOR)
		
	g_aMessage=ArrayCreate(MAX_CHARS)
	g_aColor=ArrayCreate(16)
	g_aTime=ArrayCreate(6)
	g_aPosition=ArrayCreate(16)
	
	ReadFile()
	
	set_task(TIME_TO_SEND, "SendMessage", _, _, _, "b")
	
	g_ArraySize=ArraySize(g_aMessage)
}

public ReadFile()
{
	new confdir[64], path[128]
	new File, linedata[512], message[MAX_CHARS], color[21], hold_time[21], position[16]

	get_configsdir(confdir, charsmax(confdir))

	formatex(path, charsmax(path), "%s/%s", confdir, CFG_FILE)

	File=fopen(path, "rt")

	if(!File)
	{
		log_amx("Error! File %s not exist!", CFG_FILE)
		
		set_fail_state("Config file not exist")
		
		return
	}

	while(!feof(File))
	{
		fgets(File, linedata, charsmax(linedata))
		
		if(linedata[0]==';'||linedata[0]=='/')
			continue
			
		replace(linedata, charsmax(linedata), "^n", "")
		
		parse(linedata, message, sizeof(message), color, sizeof(color), hold_time, sizeof(hold_time), position, sizeof(position))

		replace_all(color, charsmax(color), ",", " ")
		replace_all(position, charsmax(position), ",", " ")

		ArrayPushString(g_aMessage, message)
		ArrayPushString(g_aColor, color)
		ArrayPushString(g_aTime, hold_time)
		ArrayPushString(g_aPosition, position)
	}
	
	fclose(File)
}

public SendMessage()
{
	static message[MAX_CHARS]
	static color[16], rgb[3][3], r, g, b, position[16]
	static hold_time[16], hldtime[6],Float:fhold_time
	static pos[2][6], Float:x, Float:y
	
	ArrayGetString(g_aMessage, g_MsgId, message, charsmax(message))
	ArrayGetString(g_aColor, g_MsgId, color, charsmax(color))
	ArrayGetString(g_aTime, g_MsgId, hold_time, charsmax(hold_time))
	ArrayGetString(g_aPosition, g_MsgId, position, charsmax(position))
	
	parse(color, rgb[0], 3, rgb[1], 3, rgb[2], 3)
	parse(hold_time, hldtime[0], 6)
	parse(position, pos[0], 16, pos[1], 16)
	
	r=str_to_num(rgb[0])
	g=str_to_num(rgb[1])
	b=str_to_num(rgb[2])
	
	x=str_to_float(pos[0])
	y=str_to_float(pos[1])
	
	fhold_time=str_to_float(hldtime)
	
	#if defined DHUD
		set_dhudmessage(r, g, b, x, y, HUD_EFF, HUD_FIX_TIME, fhold_time, HUD_FADE_IN_TIME, HUD_FADE_OUT_TIME)
		show_dhudmessage(0, message)
	#else
		set_hudmessage(r, g, b, x, y, HUD_EFF, HUD_FIX_TIME, fhold_time, HUD_FADE_IN_TIME, HUD_FADE_OUT_TIME)
		show_hudmessage(0, message)
	#endif
	
	if(g_MsgId<g_ArraySize-1)
		g_MsgId++
	else
		g_MsgId=0
		
}