#pragma semicolon 1

#define ADMINLOAD
#define ENABLE_MODELS
#define ENABLE_VAMPIRE
#define VAMPIRE_MAX_HP 100

#include <amxmodx>
#include <cstrike>
#include <engine>
#include <fakemeta>
#include <hamsandwich>
#include <colorchat>

#if defined ENABLE_VAMPIRE
#include <fun>
#endif

#if defined ADMINLOAD
#include <adminload>
#endif

#define PLUGIN "VIP System"
#define VERSION "3.5"
#define AUTHOR "F@nt0M"

#define MAX_PLAYERS 32
#define MAX_WEAPONS 32

// #define give_user_health(%0,%1) ExecuteHamB(Ham_TakeHealth, %0, float(%1), DMG_GENERIC) // Just For Test

#define CheckBit(%1,%2)		(%1 &	(1 << (%2 & 31)))
#define SetBit(%1,%2)		(%1 |=	(1 << (%2 & 31)))
#define ClearBit(%1,%2)	(%1 &= ~(1 << (%2 & 31)))

const PRIMARY_WEAPONS_BIT_SUM = (1 << CSW_SCOUT) | (1<< CSW_XM1014) | (1 << CSW_M3) | (1<< CSW_MAC10)|(1<<CSW_AUG)|(1<<CSW_UMP45)|(1<<CSW_SG550)|(1<<CSW_GALIL)|(1<<CSW_FAMAS)|(1<<CSW_AWP)|(1<<CSW_MP5NAVY)|(1<<CSW_M249)|(1<<CSW_M4A1)|(1<<CSW_TMP)|(1<<CSW_G3SG1)|(1<<CSW_SG552)|(1<<CSW_AK47)|(1<<CSW_P90);
const SECONDARY_WEAPONS_BIT_SUM = (1<<CSW_P228)|(1<<CSW_DEAGLE)|(1<<CSW_ELITE)|(1<<CSW_FIVESEVEN)|(1<<CSW_USP)|(1<<CSW_GLOCK18);

new const g_WeaponsBrammo[] = {
	0, 52, 0, 90, 0, 32, 0, 100, 90, 0, 120, 100, 100, 90, 90, 90, 100, 120, 30, 120, 200, 32, 90, 120, 90, 0, 35, 90, 90, 0, 100
};

new g_IsVip;
new g_IsSuperVip;

new g_VipFlag;
new g_SuperVipFlag;
new g_RoundEnable;

new pcvar_Enable;
new pcvar_Bonus;
new pcvar_Grenades;
new pcvar_Weapons;

#if defined ENABLE_VAMPIRE
new pcvar_Vampire;
new pcvar_VampireHp;
new pcvar_VampireHs;
#endif

new g_ConfigDir[128];

new bool:g_DefuseInMap = false;
new g_RoundNum = 0;

new g_WeaponUsed;
new g_WeaponUsedWid[MAX_PLAYERS+1];

new g_MsgScoreAttrib;

new g_VipMenu;

new g_max_clients, g_max_entities;

#if defined ENABLE_MODELS
enum _:Weapon {
	bool:ModelEnable,
	v_Model[32],
	p_Model[32],
};
new g_WeaponsModels[MAX_WEAPONS][Weapon];
#endif

public plugin_init()
{
	register_plugin(PLUGIN, VERSION, AUTHOR);

	register_dictionary("vip_system.txt");

	register_event("TextMsg","event_start_game","a","2=#Game_Commencing", "2=#Game_will_restart_in");
	register_event("HLTV", "event_round_start", "a", "1=0", "2=0");

	RegisterHam(Ham_Spawn, "player", "player_spawn", 1);

	#if defined ENABLE_VAMPIRE
	register_event("DeathMsg", "event_death", "a", "1>0");
	#endif

	#if defined ENABLE_MODELS
	register_event("CurWeapon","checkModel","b","1=19");
	register_event("CurWeapon","checkModel","be","1=1");
	#endif

	register_clcmd("vipmenu", "vip_menu");
	register_clcmd("say /vipmenu", "vip_menu");

	if(engfunc(EngFunc_FindEntityByString,FM_NULLENT, "classname", "func_vip_safetyzone")) {
		register_message(get_user_msgid("ScoreAttrib"), "message_scoreattribute");
	}

	register_forward(FM_SetModel, "forward_set_model");

	if(engfunc(EngFunc_FindEntityByString,FM_NULLENT, "classname", "func_bomb_target")) {
		g_DefuseInMap = true;
	}

	g_MsgScoreAttrib = get_user_msgid("ScoreAttrib");

	g_max_clients = global_get(glb_maxClients);
	g_max_entities = global_get(glb_maxEntities);

	pcvar_Enable = register_cvar("amx_vip", "1");
	register_cvar("amx_vip_flag", "t");
	register_cvar("amx_vip_superflag", "r");
	register_cvar("amx_vip_round", "3");
	pcvar_Bonus = register_cvar("amx_vip_bonus", "1");
	pcvar_Grenades = register_cvar("amx_vip_grenades", "1");
	pcvar_Weapons = register_cvar("amx_vip_weapons", "1");

	#if defined ENABLE_VAMPIRE
	pcvar_Vampire = register_cvar("amx_vip_vampire", "1");
	pcvar_VampireHp = register_cvar("amx_vip_vampire_hp", "10");
	pcvar_VampireHs = register_cvar("amx_vip_vampire_hs", "15");
	#endif

	server_cmd("exec %s/vip_system/vip_system.cfg", g_ConfigDir);
}

public plugin_cfg()
{
	new flag[2], title[128];
	
	get_cvar_string("amx_vip_flag", flag, 1);
	g_VipFlag = read_flags(flag);

	get_cvar_string("amx_vip_superflag", flag, 1);
	g_SuperVipFlag = read_flags(flag);

	g_RoundEnable = get_cvar_num("amx_vip_round");

	format(title, 127, "%L", LANG_SERVER, "VIP_MENU_TITLE");
	g_VipMenu = menu_create(title, "vipmenu_handler");

	#if !defined ENABLE_MODELS
	get_localinfo("amxx_configsdir", g_ConfigDir, 127);
	#endif

	if (!loadConfigWeapons()) {
		set_pcvar_num(pcvar_Enable, 0);
	}

	formatex(title,127, "%L^n^n\y%s by %s", LANG_SERVER, "VIP_MENU_EXIT", PLUGIN, AUTHOR);
	menu_additem(g_VipMenu, title, "EXIT");
	menu_setprop(g_VipMenu, MPROP_EXIT, MEXIT_NEVER);
}

public plugin_end()
{
	menu_destroy(g_VipMenu);
}

#if defined ENABLE_MODELS
public plugin_precache()
{
	get_localinfo("amxx_configsdir", g_ConfigDir, 127);

	if (loadConfigModels()) {
		for (new i = 0; i < MAX_WEAPONS; i++) {
			if (g_WeaponsModels[i][ModelEnable]) {
				precache_model(g_WeaponsModels[i][v_Model]);
				precache_model(g_WeaponsModels[i][p_Model]);
			}
		}
	}
}
#endif

#if defined ADMINLOAD
public adminload_connect(id, flags)
{
	if (flags & g_VipFlag) {

		SetBit(g_IsVip, id);

		if (flags & g_SuperVipFlag) {
			SetBit(g_IsSuperVip, id);
		}

		new name[32];
		get_user_name(id, name, 31);
		ColorChat(0, NORMAL, "%L", LANG_SERVER, "VIP_CONNECTED", name);
	}
}

public adminload_disconnect(id)
{
	ClearBit(g_IsVip, id);
	ClearBit(g_IsSuperVip, id);
}
#else
public client_putinserver(id)
{
	new flags = get_user_flags(id);
	if (flags & g_VipFlag) {

		SetBit(g_IsVip, id);

		new name[32];
		get_user_name(id, name, 31);
		ColorChat(0, NORMAL, "%L", LANG_SERVER, "VIP_CONNECTED", name);

		if (flags & g_SuperVipFlag) {
			SetBit(g_IsSuperVip, id);
		}
	}
}

public client_disconnect(id)
{
	ClearBit(g_IsVip, id);
	ClearBit(g_IsSuperVip, id);
}
#endif

public event_start_game()
{
	g_RoundNum = 0;
}

public event_round_start()
{
	g_RoundNum++;
}

public player_spawn(id)
{
	if (get_pcvar_num(pcvar_Enable) == 1 && is_user_alive(id) && CheckBit(g_IsVip, id)) {

		if (get_pcvar_num(pcvar_Bonus) == 1) {
			give_weapon_ex(id, "weapon_deagle");

			cs_set_user_armor(id, 100, CS_ARMOR_VESTHELM);

			if (g_DefuseInMap && cs_get_user_team(id) == CS_TEAM_CT) {
				cs_set_user_defuse(id, 1);
			}
		}

		if (get_pcvar_num(pcvar_Grenades) == 1) {
			give_item_ex(id, "weapon_hegrenade");
			give_item_ex(id, "weapon_flashbang");
			cs_set_user_bpammo(id, CSW_FLASHBANG, 2);
		}

		if (get_pcvar_num(pcvar_Weapons) == 1 && g_RoundNum >= g_RoundEnable) {
			ClearBit(g_WeaponUsed, id);
			if (g_WeaponUsedWid[id] > 0) {
				cs_set_user_bpammo(id, g_WeaponUsedWid[id], g_WeaponsBrammo[ g_WeaponUsedWid[id] ]);
			} else if(!cs_get_user_hasprim(id) && !displayed_menu(id)) {
				menu_display(id, g_VipMenu, 0);
			}
		}

		message_begin(MSG_ALL, g_MsgScoreAttrib);
		write_byte(id);
		write_byte(4);
		message_end();
	}
}

#if defined ENABLE_VAMPIRE
public event_death()
{
	static id, hp;

	if (get_pcvar_num(pcvar_Enable) == 0 || !get_pcvar_num(pcvar_Vampire)) {
		return PLUGIN_CONTINUE;
	}

	// Killer id
	id = read_data(1);
	
	if (id == read_data(2)) {
		return PLUGIN_CONTINUE;
	}
	
	if (!CheckBit(g_IsSuperVip, id)) {
		return PLUGIN_CONTINUE;
	}

	hp = get_user_health(id);
	
	if (hp < VAMPIRE_MAX_HP) {
		
		if ((read_data(3) == 1) && (read_data(5) == 0)) {
			hp += get_pcvar_num(pcvar_VampireHs);
		} else {
			hp += get_pcvar_num(pcvar_VampireHp);
		}
		
		if (hp > VAMPIRE_MAX_HP) {
			hp = VAMPIRE_MAX_HP;
		}
		
		set_user_health(id, hp);
	}

	return PLUGIN_CONTINUE;
}
#endif

public vip_menu(id)
{
	if (get_pcvar_num(pcvar_Enable) == 0 || get_pcvar_num(pcvar_Weapons) == 0) {
		ColorChat(id, NORMAL, "%L", LANG_SERVER, "VIP_WEAPONS_DISABLED");
		return PLUGIN_HANDLED;
	}

	if (!is_user_alive(id)) {
		ColorChat(id, NORMAL, "%L", LANG_SERVER, "VIP_WEAPONS_DEAD");
		return PLUGIN_HANDLED;
	}

	if (!CheckBit(g_IsVip, id)) {
		return PLUGIN_HANDLED;
	}

	if (g_RoundNum < g_RoundEnable) {
		ColorChat(id, NORMAL, "%L", LANG_SERVER, "VIP_ALLOW_IN_ROUND", g_RoundEnable);
		return PLUGIN_HANDLED;
	}

	if (CheckBit(g_WeaponUsed, id)) {
		ColorChat(id, NORMAL,  "%L", LANG_SERVER, "VIP_ALREADY_USED");
		return PLUGIN_HANDLED;
	}

	menu_display(id, g_VipMenu, 0);

	return PLUGIN_CONTINUE;
}

public vipmenu_handler(id, menu, item)
{
	if(!is_user_alive(id)) {
		ColorChat(id, NORMAL, "%L", LANG_SERVER, "VIP_WEAPONS_DEAD");
		return PLUGIN_HANDLED;
	}

	if (CheckBit(g_WeaponUsed, id)) {
		ColorChat(id, NORMAL,  "%L", LANG_SERVER, "VIP_ALREADY_USED");
		return PLUGIN_HANDLED;
	}

	new round, weapon[32], title[64], callback;
	menu_item_getinfo(menu, item, round, weapon, 31, title, 63, callback);

	if (equal(weapon, "EXIT")) {
		return PLUGIN_HANDLED;
	}

	if (round > 0 && round > g_RoundNum) {
		return PLUGIN_HANDLED;
	}


	give_weapon_ex(id, weapon);

	SetBit(g_WeaponUsed, id);
	g_WeaponUsedWid[id] = get_weaponid(weapon);

	return PLUGIN_CONTINUE;
}

public vipmenu_callback(id, menu, item)
{
	static round, weapon[32], title[64], callback;
	menu_item_getinfo(menu, item, round, weapon, weapon[31], title, 63, callback);

	if (round > 0 && round > g_RoundNum) {
		return ITEM_DISABLED;
	}

	return ITEM_ENABLED;
}

public message_scoreattribute(msg_id, dest, receiver)
{	
	static id; 

	id = get_msg_arg_int(1);
	if (CheckBit(g_IsVip, id) && !get_msg_arg_int(2)) {
		set_msg_arg_int(2, ARG_BYTE, 4);
	}
}

public forward_set_model(ent, const model[]) 
{
	if (!pev_valid(ent) || !equali(model, "models/w_", 8) || equali(model, "models/w_weaponbox.mdl")) {
		return FMRES_IGNORED;
	}

	new id = pev(ent, pev_owner);
	if (!(1 <= id <= g_max_clients))
		return FMRES_IGNORED;

	static class[32];
	pev(ent, pev_classname, class, 31);
	if (!equal(class, "weaponbox"))
		return FMRES_IGNORED;

	for (new i = g_max_clients + 1; i < g_max_entities; ++i) {
		if (!pev_valid(i) || ent != pev(i, pev_owner)) {
			continue;
		}

		if (g_WeaponUsedWid[id] > 0 && g_WeaponUsedWid[id] == cs_get_weapon_id(i)) {
			g_WeaponUsedWid[id] = 0;
		}

		return FMRES_IGNORED;
	}

	return FMRES_IGNORED;
}

#if defined ENABLE_MODELS
public checkModel(id)
{
 	new wid = read_data(2);

 	if (CheckBit(g_IsVip, id) && wid == CSW_DEAGLE && g_WeaponsModels[wid][ModelEnable]) {
 		set_pev(id, pev_viewmodel2, g_WeaponsModels[wid][v_Model]);
 		set_pev(id, pev_weaponmodel2, g_WeaponsModels[wid][p_Model]);
 		return PLUGIN_CONTINUE;
 	}

 	if (g_WeaponUsedWid[id] == 0 || g_WeaponUsedWid[id] != wid) {
 		return PLUGIN_CONTINUE;
 	}

 	if (g_WeaponsModels[wid][ModelEnable]) {
 		set_pev(id, pev_viewmodel2, g_WeaponsModels[wid][v_Model]);
 		set_pev(id, pev_weaponmodel2, g_WeaponsModels[wid][p_Model]);
 	}

 	return PLUGIN_CONTINUE;
}

bool:loadConfigModels()
{
	for (new i = 0; i < MAX_WEAPONS; i++) {
		g_WeaponsModels[i][ModelEnable] = false;
	}

	new configFile[128];
	format(configFile, 127, "%s/vip_system/vip_models.ini", g_ConfigDir);
	log_amx("configFile %s", configFile);

	if (!file_exists(configFile)) {
		return false;
	}

	new wid, text[512], weapon[32], v_model[32], p_model[32];

	new file = fopen(configFile, "r");
	if (file) {
		while (!feof(file)) {
			fgets(file, text, 127);
			trim(text);

			if (!text[0] || text[0]==';') {
				continue;
			}

			weapon[0] = '^0';
			v_model[0] = '^0';
			p_model[0] = '^0';

			parse(text, weapon, 31, v_model, 31, p_model, 31);


			if (!equal(weapon, "weapon_", 7)) {
				continue;
			}

			wid = get_weaponid(weapon);
			g_WeaponsModels[wid][ModelEnable] = true;
			copy(g_WeaponsModels[wid][v_Model], 31, v_model);
			copy(g_WeaponsModels[wid][p_Model], 31, p_model);
		}

		fclose(file);
	}

	return true;
}
#endif

bool:loadConfigWeapons()
{
	new configFile[128];
	format(configFile, 127, "%s/vip_system/vip_menu.ini", g_ConfigDir);

	if (!file_exists(configFile)) {
		return false;
	}

	new text[128], title[64], weapon[32], round_str[3], round;

	new callback = menu_makecallback("vipmenu_callback");

	new file = fopen(configFile, "r");
	if (file) {
		while (!feof(file)) {
			fgets(file, text, 127);
			trim(text);

			if (!text[0] || text[0]==';') {
				continue;
			}

			title[0] = '^0';
			weapon[0] = '^0';
			round_str[0] = '^0';

			if (parse(text, title, 63, weapon, 31, round_str, 2) < 2) {
				continue;
			}

			if (!equal(weapon, "weapon_", 7)) {
				continue;
			}

			round = round_str[0] ? str_to_num(round_str) : 0;
			menu_additem(g_VipMenu, title, weapon, round, callback);

			// log_amx("[VIP] Add to menu %s wapon %s round %s (%d)", title, weapon, round_str, round);
		}

		fclose(file);
	}

	return true;
}

stock give_item_ex(index, const item[]) {
	if (!equal(item, "weapon_", 7) && !equal(item, "ammo_", 5) && !equal(item, "item_", 5) && !equal(item, "tf_weapon_", 10))
		return 0;

	new ent = engfunc(EngFunc_CreateNamedEntity, engfunc(EngFunc_AllocString, item));
	if (!pev_valid(ent))
		return 0;

	new Float:origin[3];
	pev(index, pev_origin, origin);
	set_pev(ent, pev_origin, origin);
	set_pev(ent, pev_spawnflags, pev(ent, pev_spawnflags) | SF_NORESPAWN);
	dllfunc(DLLFunc_Spawn, ent);

	new save = pev(ent, pev_solid);
	dllfunc(DLLFunc_Touch, ent, index);
	if (pev(ent, pev_solid) != save)
		return ent;

	engfunc(EngFunc_RemoveEntity, ent);

	return -1;
}

stock give_weapon_ex(id, weapon[])
{
	static weapons[32], num, wid, wtype, wname[32], bool:exists, ent, ent_box, i;

	wid = get_weaponid(weapon);
	if ((1 << wid) & PRIMARY_WEAPONS_BIT_SUM) {
		wtype = PRIMARY_WEAPONS_BIT_SUM;
	} else if ((1 << wid) & SECONDARY_WEAPONS_BIT_SUM) {
		wtype = SECONDARY_WEAPONS_BIT_SUM;
	}
	
	num = 0;
	get_user_weapons(id, weapons, num);
	
	exists = false;
	for (i = 0; i < num; i++) {
		if (wid == weapons[i]) {
			exists = true;
			break;
		}

		if ((1 << weapons[i]) & wtype) {
			get_weaponname(weapons[i], wname, 31);

			ent = -1;
			while ((ent = engfunc(EngFunc_FindEntityByString, ent, "classname", wname)) && pev(ent, pev_owner) != id) {}
			if(!ent) continue;

			engclient_cmd(id, "drop", wname);

			ent_box = pev(ent, pev_owner);
			if (!ent_box || ent_box == id) continue;

			dllfunc(DLLFunc_Think, ent_box);
		}
	}

	if (!exists) {
		give_item_ex(id, weapon);
	}

	if (0 < wid <= 30) {
		cs_set_user_bpammo(id, wid, g_WeaponsBrammo[wid]);
	}
}

stock bool:displayed_menu(id)
{
	new oldmenu, newmenu;
	player_menu_info(id, oldmenu, newmenu);

	return (newmenu != -1 || oldmenu > 0) ? true : false;
}