/* AMX Mod X Script
*
*	Simple Redirection plugin for AMXX.
*	Orginal ode by Sonic (sonic@codet.de).
*	Modified and made for AMXX by BigBaller.
*	Translated and edited by STR@TEG, especially for c-s.net.ua
*	
*	Place following cvars in amxx.cfg or change their in this file:
*	
*	amx_rd_max_players <x>		// - Begin redirection, when more the x players connected (0 = redirect all players).
*	amx_rd_server_pw <password>	// - Password for the amx_rd_server_ip (if needed).
*	amx_rd_server_ip <ip>		// - Redirect to this server ip.
*	amx_rd_server_port <port>	// - Redirect server port.
*	
*	
*	To disable this plugin, set amx_rd_max_players to 33 or remove the line simple_redirect.amxx from plugins.ini.
*
*
*
* AMX Mod X 
*
*	    AMXX.
*	   Sonic (sonic@codet.de).
*	    AMXX BigBaller.
*	   STR@TEG,   c-s.net.ua
*	
*	    amxx.cfg      :
*	
*	amx_rd_max_players <x>		// -  ,         x (0 =   ).
*	amx_rd_server_pw <password>	// -       amx_rd_server_ip ( ).
*	amx_rd_server_ip <ip>		// -    IP .
*	amx_rd_server_port <port>	// -    .
*	
*	
*	  ,    amx_rd_max_players "33"    simple_redirect.amxx   plugins.ini.
*/

#include <amxmodx>
#include <amxmisc>

new pcvar_max_players, pcvar_server_pw, pcvar_server_ip, pcvar_server_port

public plugin_init()
{
	register_plugin("Simple Redirection", "1.1", "BigBaller | STR@TEG")
	pcvar_max_players = register_cvar("amx_rd_max_players", "0")
	pcvar_server_pw = register_cvar("amx_rd_server_pw", ",  ")
	pcvar_server_ip = register_cvar("amx_rd_server_ip", "ip  ")
	pcvar_server_port = register_cvar("amx_rd_server_port", " ")
}

public client_connect(id)
{
	new rd_max_players = get_pcvar_num(pcvar_max_players)
	new rd_server_port = get_pcvar_num(pcvar_server_port)
	new rd_server_ip[16], rd_server_pw[32]
	get_pcvar_string(pcvar_server_ip, rd_server_ip, charsmax(rd_server_ip))
	get_pcvar_string(pcvar_server_pw, rd_server_pw, charsmax(rd_server_pw))
	
	if (get_playersnum() >= rd_max_players)
	{
		if (!equal(rd_server_pw, ""))
		{
			client_cmd(id, "echo ^"[AMXX] Simple Redirection - set password to ^"%s^"^"", rd_server_pw)
			client_cmd(id, "password ^"%s^"", rd_server_pw)
		}
		
		client_cmd(id, "echo ^"[AMXX] Simple Redirection -  redirecting to %s:%d^"", rd_server_ip, rd_server_port)
		client_cmd(id, "Connect %s:%d", rd_server_ip, rd_server_port)
	}
	return PLUGIN_CONTINUE
}
